/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.key.query;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jnosql.diana.api.Params;
import org.jnosql.diana.api.QueryException;
import org.jnosql.diana.api.Value;
import org.jnosql.diana.api.key.BucketManager;
import org.jnosql.diana.api.key.KeyValueEntity;
import org.jnosql.diana.api.key.KeyValuePreparedStatement;
import org.jnosql.diana.api.key.query.DefaultKeyValuePreparedStatement;
import org.jnosql.diana.api.key.query.Values;
import org.jnosql.query.PutQuery;
import org.jnosql.query.PutQuerySupplier;

final class PutQueryParser {
    private final PutQuerySupplier supplier = PutQuerySupplier.getSupplier();

    PutQueryParser() {
    }

    List<Value> query(String query, BucketManager manager) {
        PutQuery putQuery = (PutQuery)this.supplier.apply((Object)query);
        Params params = new Params();
        Value key = Values.getValue(putQuery.getKey(), params);
        Value value = Values.getValue(putQuery.getValue(), params);
        Optional ttl = putQuery.getTtl();
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        KeyValueEntity<Object> entity = KeyValueEntity.of(key.get(), value.get());
        if (ttl.isPresent()) {
            manager.put(entity, (Duration)ttl.get());
        } else {
            manager.put(entity);
        }
        return Collections.emptyList();
    }

    public KeyValuePreparedStatement prepare(String query, BucketManager manager) {
        PutQuery putQuery = (PutQuery)this.supplier.apply((Object)query);
        Params params = new Params();
        Value key = Values.getValue(putQuery.getKey(), params);
        Value value = Values.getValue(putQuery.getValue(), params);
        Optional ttl = putQuery.getTtl();
        return DefaultKeyValuePreparedStatement.put(key, value, manager, params, ttl.orElse(null), query);
    }
}

