/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.key.query;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jnosql.diana.api.Params;
import org.jnosql.diana.api.QueryException;
import org.jnosql.diana.api.Value;
import org.jnosql.diana.api.key.BucketManager;
import org.jnosql.diana.api.key.KeyValuePreparedStatement;
import org.jnosql.diana.api.key.query.DefaultKeyValuePreparedStatement;
import org.jnosql.diana.api.key.query.Values;
import org.jnosql.query.RemoveQuery;
import org.jnosql.query.RemoveQuerySupplier;

final class RemoveQueryParser {
    private final RemoveQuerySupplier supplier = RemoveQuerySupplier.getSupplier();

    RemoveQueryParser() {
    }

    List<Value> query(String query, BucketManager manager) {
        RemoveQuery delQuery = (RemoveQuery)this.supplier.apply((Object)query);
        Params params = new Params();
        List values = delQuery.getKeys().stream().map(k -> Values.getValue(k, params)).collect(Collectors.toList());
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        List keys = values.stream().map(Value::get).collect(Collectors.toList());
        manager.remove(keys);
        return Collections.emptyList();
    }

    public KeyValuePreparedStatement prepare(String query, BucketManager manager) {
        RemoveQuery delQuery = (RemoveQuery)this.supplier.apply((Object)query);
        Params params = new Params();
        List<Value> values = delQuery.getKeys().stream().map(k -> Values.getValue(k, params)).collect(Collectors.toList());
        return DefaultKeyValuePreparedStatement.del(values, manager, params, query);
    }
}

