/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.angularfaces;

import de.beyondjava.angularFaces.core.ELTools;
import de.beyondjava.angularFaces.core.tagTransformer.AngularTagDecorator;
import java.util.ArrayList;
import javax.faces.view.facelets.TagDecorator;
import org.joinfaces.autoconfigure.angularfaces.AngularfacesProperties;
import org.joinfaces.autoconfigure.javaxfaces.JavaxFaces2_0Properties;
import org.joinfaces.autoconfigure.javaxfaces.JavaxFacesAutoConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;

@Configuration
@EnableConfigurationProperties(value={AngularfacesProperties.class})
@ConditionalOnClass(value={ELTools.class})
@AutoConfigureBefore(value={JavaxFacesAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class AngularfacesAutoConfiguration {
    @Bean
    public BeanPostProcessor angularfacesJavaxFacesPropertiesPostProcessor() {
        return new JavaxFacesPropertiesPostProcessor();
    }

    static class JavaxFacesPropertiesPostProcessor
    implements BeanPostProcessor {
        JavaxFacesPropertiesPostProcessor() {
        }

        public Object postProcessBeforeInitialization(@Nullable Object bean, @Nullable String beanName) throws BeansException {
            if (bean instanceof JavaxFaces2_0Properties) {
                JavaxFaces2_0Properties properties = (JavaxFaces2_0Properties)bean;
                if (properties.getFaceletsDecorators() == null) {
                    properties.setFaceletsDecorators(new ArrayList<Class<? extends TagDecorator>>(1));
                }
                if (!properties.getFaceletsDecorators().contains(AngularTagDecorator.class)) {
                    properties.getFaceletsDecorators().add(AngularTagDecorator.class);
                }
            }
            return bean;
        }
    }
}

