/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.icefaces;

import io.undertow.Undertow;
import org.icefaces.impl.application.SessionExpiredListener;
import org.icefaces.impl.application.WindowScopeManager;
import org.icefaces.impl.push.servlet.ICEpushResourceHandlerLifecycle;
import org.icefaces.util.EnvUtils;
import org.joinfaces.autoconfigure.icefaces.IcefacesProperties;
import org.joinfaces.autoconfigure.icefaces.WindowScope;
import org.springframework.beans.factory.config.CustomScopeConfigurer;
import org.springframework.beans.factory.config.Scope;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={EnvUtils.class, WindowScopeManager.class})
@EnableConfigurationProperties(value={IcefacesProperties.class})
public class IcefacesAutoConfiguration {
    @Bean
    public static CustomScopeConfigurer windowScopeConfigurer() {
        CustomScopeConfigurer windowScopeConfigurer = new CustomScopeConfigurer();
        windowScopeConfigurer.addScope("window", (Scope)new WindowScope());
        return windowScopeConfigurer;
    }

    @Configuration
    @ConditionalOnClass(value={Undertow.class})
    public static class IcefacesUndertowAutoConfiguration {
        @Bean
        public WebServerFactoryCustomizer<UndertowServletWebServerFactory> icefacesUndertowFactoryCustomizer() {
            return factory -> factory.addInitializers(new ServletContextInitializer[]{servletContext -> {
                servletContext.addListener(ICEpushResourceHandlerLifecycle.class);
                servletContext.addListener(SessionExpiredListener.class);
                servletContext.addListener(WindowScopeManager.SetupTimer.class);
            }});
        }
    }
}

