/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.rewrite;

import javax.servlet.Filter;
import org.joinfaces.autoconfigure.rewrite.ApplicationContextProvider;
import org.joinfaces.autoconfigure.rewrite.RewriteFilterProperties;
import org.joinfaces.autoconfigure.rewrite.RewriteProperties;
import org.joinfaces.autoconfigure.rewrite.SpringBootAnnotationConfigProvider;
import org.joinfaces.autoconfigure.rewrite.SpringBootBeanNameResolver;
import org.joinfaces.autoconfigure.servlet.WebFragmentRegistrationBean;
import org.ocpsoft.rewrite.servlet.RewriteFilter;
import org.ocpsoft.rewrite.servlet.impl.RewriteServletContextListener;
import org.ocpsoft.rewrite.servlet.impl.RewriteServletRequestListener;
import org.ocpsoft.rewrite.spring.SpringExpressionLanguageProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.ConditionalOnMissingFilterBean;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={RewriteProperties.class, RewriteFilterProperties.class})
@ConditionalOnClass(value={RewriteFilter.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class RewriteAutoConfiguration {
    @Bean
    @DependsOn(value={"applicationContextProvider"})
    public WebFragmentRegistrationBean rewriteWebFragmentRegistrationBean() {
        WebFragmentRegistrationBean bean = new WebFragmentRegistrationBean();
        bean.getListeners().add(RewriteServletRequestListener.class);
        bean.getListeners().add(RewriteServletContextListener.class);
        return bean;
    }

    @Bean
    @DependsOn(value={"applicationContextProvider"})
    @ConditionalOnMissingFilterBean
    public FilterRegistrationBean<RewriteFilter> rewriteFilterRegistrationBean(RewriteFilterProperties rewriteFilterProperties) {
        FilterRegistrationBean rewriteFilterRegistrationBean = new FilterRegistrationBean((Filter)new RewriteFilter(), new ServletRegistrationBean[0]);
        rewriteFilterRegistrationBean.setName("OCPsoft Rewrite Filter");
        rewriteFilterRegistrationBean.setEnabled(rewriteFilterProperties.isEnabled());
        rewriteFilterRegistrationBean.setOrder(rewriteFilterProperties.getOrder());
        rewriteFilterRegistrationBean.setUrlPatterns(rewriteFilterProperties.getUrlPatterns());
        rewriteFilterRegistrationBean.setDispatcherTypes(rewriteFilterProperties.getDispatcherTypes());
        return rewriteFilterRegistrationBean;
    }

    @Bean
    public ApplicationContextProvider applicationContextProvider() {
        return new ApplicationContextProvider();
    }

    @Bean
    public SpringExpressionLanguageProvider rewriteExpressionLanguageProvider() {
        return new SpringExpressionLanguageProvider();
    }

    @Bean
    public SpringBootBeanNameResolver rewriteBeanNameResolver(ApplicationContext applicationContext) {
        return new SpringBootBeanNameResolver(applicationContext);
    }

    @Bean
    public SpringBootAnnotationConfigProvider rewriteAnnotationConfigProvider(RewriteProperties rewriteProperties) {
        return new SpringBootAnnotationConfigProvider(rewriteProperties.getAnnotationConfigProvider());
    }
}

