/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.support.spring.actuator;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import java.util.Map;
import org.jolokia.server.core.http.AgentServlet;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletPath;
import org.springframework.boot.web.servlet.ServletContextInitializer;

public class JolokiaServletRegistration
implements ServletContextInitializer {
    private final Map<String, String> initParameters;
    private final DispatcherServletPath dispatcherServletPath;
    private final WebEndpointProperties webEndpointProperties;

    public JolokiaServletRegistration(Map<String, String> initParameters, WebEndpointProperties webEndpointProperties, DispatcherServletPath dispatcherServletPath) {
        this.initParameters = initParameters;
        this.dispatcherServletPath = dispatcherServletPath;
        this.webEndpointProperties = webEndpointProperties;
    }

    public void onStartup(ServletContext servletContext) {
        String prefix = this.dispatcherServletPath.getPrefix();
        String endpointsBasePath = this.webEndpointProperties.getBasePath();
        String jolokiaPath = "jolokia";
        Map mapping = this.webEndpointProperties.getPathMapping();
        if (mapping.containsKey(jolokiaPath)) {
            jolokiaPath = (String)mapping.get(jolokiaPath);
        }
        ServletRegistration.Dynamic reg = servletContext.addServlet("jolokia", AgentServlet.class);
        reg.setInitParameters(this.initParameters);
        reg.addMapping(new String[]{prefix + endpointsBasePath + "/" + jolokiaPath + "/*"});
    }
}

