/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen;

import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jooq.Record;
import org.jooq.codegen.AbstractGenerator;
import org.jooq.codegen.AbstractGeneratorStrategy;
import org.jooq.codegen.GenerationUtil;
import org.jooq.codegen.Generator;
import org.jooq.codegen.GeneratorStrategy;
import org.jooq.impl.AbstractRoutine;
import org.jooq.impl.TableRecordImpl;
import org.jooq.impl.UDTRecordImpl;
import org.jooq.impl.UpdatableRecordImpl;
import org.jooq.meta.AttributeDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.Definition;
import org.jooq.meta.ParameterDefinition;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.TypedElementDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.tools.StringUtils;

class GeneratorStrategyWrapper
extends AbstractGeneratorStrategy {
    private final Map<Class<?>, Map<Integer, Set<String>>> reservedColumns = new HashMap();
    final Generator generator;
    final GeneratorStrategy delegate;
    final AbstractGenerator.Language language;

    GeneratorStrategyWrapper(Generator generator, GeneratorStrategy delegate, AbstractGenerator.Language language) {
        this.generator = generator;
        this.delegate = delegate;
        this.language = language;
    }

    @Override
    public String getTargetDirectory() {
        return this.delegate.getTargetDirectory();
    }

    @Override
    public void setTargetDirectory(String directory) {
        this.delegate.setTargetDirectory(directory);
    }

    @Override
    public String getTargetPackage() {
        return this.delegate.getTargetPackage();
    }

    @Override
    public void setTargetPackage(String packageName) {
        this.delegate.setTargetPackage(packageName);
    }

    @Override
    public void setInstanceFields(boolean instanceFields) {
        this.delegate.setInstanceFields(instanceFields);
    }

    @Override
    public boolean getInstanceFields() {
        return this.delegate.getInstanceFields();
    }

    @Override
    public void setJavaBeansGettersAndSetters(boolean javaBeansGettersAndSetters) {
        this.delegate.setJavaBeansGettersAndSetters(javaBeansGettersAndSetters);
    }

    @Override
    public boolean getJavaBeansGettersAndSetters() {
        return this.delegate.getJavaBeansGettersAndSetters();
    }

    @Override
    public String getFileHeader(Definition definition, GeneratorStrategy.Mode mode) {
        return this.delegate.getFileHeader(definition, mode);
    }

    @Override
    public String getJavaIdentifier(Definition definition) {
        CatalogDefinition catalog;
        SchemaDefinition schema;
        String identifier = this.getFixedJavaIdentifier(definition);
        if (identifier != null) {
            return identifier;
        }
        identifier = GenerationUtil.convertToIdentifier(this.delegate.getJavaIdentifier(definition), this.language);
        if (definition instanceof ColumnDefinition || definition instanceof AttributeDefinition) {
            TypedElementDefinition e = (TypedElementDefinition)definition;
            if (identifier.equals(this.getJavaIdentifier(e.getContainer()))) {
                return identifier + "_";
            }
            if (identifier.equals(this.getJavaPackageName(e.getContainer()).replaceAll("\\..*", ""))) {
                return identifier + "_";
            }
        } else if (definition instanceof TableDefinition ? identifier.equals(this.getJavaIdentifier((Definition)(schema = definition.getSchema()))) : definition instanceof SchemaDefinition && identifier.equals(this.getJavaIdentifier((Definition)(catalog = definition.getCatalog())))) {
            return identifier + "_";
        }
        return identifier;
    }

    @Override
    public String getJavaSetterName(Definition definition, GeneratorStrategy.Mode mode) {
        return this.disambiguateMethod(definition, GenerationUtil.convertToIdentifier(this.delegate.getJavaSetterName(definition, mode), this.language));
    }

    @Override
    public String getJavaGetterName(Definition definition, GeneratorStrategy.Mode mode) {
        return this.disambiguateMethod(definition, GenerationUtil.convertToIdentifier(this.delegate.getJavaGetterName(definition, mode), this.language));
    }

    @Override
    public String getJavaMethodName(Definition definition, GeneratorStrategy.Mode mode) {
        String methodName = this.delegate.getJavaMethodName(definition, mode);
        methodName = this.overload(definition, mode, methodName);
        methodName = GenerationUtil.convertToIdentifier(methodName, this.language);
        return this.disambiguateMethod(definition, methodName);
    }

    private String overload(Definition definition, GeneratorStrategy.Mode mode, String identifier) {
        if (!StringUtils.isBlank((String)definition.getOverload())) {
            identifier = identifier + this.getOverloadSuffix(definition, mode, definition.getOverload());
        }
        return identifier;
    }

    private String disambiguateMethod(Definition definition, String method) {
        RoutineDefinition routine;
        Set<String> reserved = null;
        if (definition instanceof AttributeDefinition) {
            reserved = this.reservedColumns(UDTRecordImpl.class, 0);
        } else if (definition instanceof ColumnDefinition) {
            reserved = ((TableDefinition)((ColumnDefinition)definition).getContainer()).getPrimaryKey() != null ? this.reservedColumns(UpdatableRecordImpl.class, 0) : this.reservedColumns(TableRecordImpl.class, 0);
        } else if (definition instanceof ParameterDefinition) {
            reserved = this.reservedColumns(AbstractRoutine.class, 0);
        } else if (definition instanceof RoutineDefinition && (routine = (RoutineDefinition)definition).getPackage() instanceof UDTDefinition && routine.getInParameters().size() > 0 && "SELF".equalsIgnoreCase(((ParameterDefinition)routine.getInParameters().get(0)).getName())) {
            reserved = this.reservedColumns(UDTRecordImpl.class, routine.getInParameters().size() - 1);
        }
        if (reserved != null) {
            if (reserved.contains(method)) {
                return method + "_";
            }
            if (method.startsWith("set")) {
                String base = method.substring(3);
                if (reserved.contains("get" + base) || reserved.contains("is" + base)) {
                    return method + "_";
                }
            }
        }
        return method;
    }

    private Set<String> reservedColumns(Class<?> clazz, int length) {
        Set<String> result;
        if (clazz == null) {
            return Collections.emptySet();
        }
        Map<Integer, Set<String>> map = this.reservedColumns.get(clazz);
        if (map == null) {
            map = new HashMap<Integer, Set<String>>();
            this.reservedColumns.put(clazz, map);
        }
        if ((result = map.get(length)) == null) {
            result = new HashSet<String>();
            map.put(length, result);
            result.addAll(this.reservedColumns(clazz.getSuperclass(), length));
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                result.addAll(this.reservedColumns(clazz2, length));
            }
            for (GenericDeclaration genericDeclaration : clazz.getDeclaredMethods()) {
                if (((Method)genericDeclaration).getParameterTypes().length != length) continue;
                result.add(((Method)genericDeclaration).getName());
            }
            if (this.language == AbstractGenerator.Language.SCALA) {
                for (AnnotatedElement annotatedElement : clazz.getDeclaredFields()) {
                    result.add(((Field)annotatedElement).getName());
                }
            }
        }
        return result;
    }

    @Override
    public String getJavaClassExtends(Definition definition, GeneratorStrategy.Mode mode) {
        return this.delegate.getJavaClassExtends(definition, mode);
    }

    @Override
    public List<String> getJavaClassImplements(Definition definition, GeneratorStrategy.Mode mode) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.delegate.getJavaClassImplements(definition, mode));
        if (mode == GeneratorStrategy.Mode.INTERFACE && this.generator.generateSerializableInterfaces()) {
            result.add(Serializable.class.getName());
        } else if (!(mode != GeneratorStrategy.Mode.POJO || !this.generator.generateSerializablePojos() || this.generator.generateInterfaces() && this.generator.generateSerializableInterfaces())) {
            result.add(Serializable.class.getName());
        }
        return new ArrayList<String>(result);
    }

    @Override
    public String getJavaClassName(Definition definition, GeneratorStrategy.Mode mode) {
        String name = this.getFixedJavaClassName(definition);
        if (name != null) {
            return name;
        }
        if (definition instanceof TableDefinition && !this.generator.generateRecords() && mode == GeneratorStrategy.Mode.RECORD) {
            return Record.class.getSimpleName();
        }
        String className = this.delegate.getJavaClassName(definition, mode);
        className = this.overload(definition, mode, className);
        className = GenerationUtil.convertToIdentifier(className, this.language);
        className = GenerationUtil.escapeWindowsForbiddenNames(className);
        return className;
    }

    @Override
    public String getJavaPackageName(Definition definition, GeneratorStrategy.Mode mode) {
        if (!this.generator.generateRecords() && mode == GeneratorStrategy.Mode.RECORD && definition instanceof TableDefinition) {
            return Record.class.getPackage().getName();
        }
        Object[] split = this.delegate.getJavaPackageName(definition, mode).split("\\.");
        for (int i = 0; i < split.length; ++i) {
            split[i] = GenerationUtil.convertToIdentifier((String)split[i], this.language);
            split[i] = GenerationUtil.escapeWindowsForbiddenNames((String)split[i]);
        }
        return StringUtils.join((Object[])split, (String)".").replaceAll("\\._?\\.", ".");
    }

    @Override
    public String getJavaMemberName(Definition definition, GeneratorStrategy.Mode mode) {
        String identifier = GenerationUtil.convertToIdentifier(this.delegate.getJavaMemberName(definition, mode), this.language);
        if (identifier.equals(this.getJavaPackageName(definition, mode).replaceAll("\\..*", ""))) {
            return identifier + "_";
        }
        return identifier;
    }

    @Override
    public String getOverloadSuffix(Definition definition, GeneratorStrategy.Mode mode, String overloadIndex) {
        return this.delegate.getOverloadSuffix(definition, mode, overloadIndex);
    }
}

