/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.extensions.jpa;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.persistence.AttributeConverter;
import javax.persistence.Entity;
import org.h2.Driver;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;
import org.jooq.DSLContext;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.impl.JPAConverter;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.extensions.jpa.AttributeConverterExtractor;
import org.jooq.meta.h2.H2Database;
import org.jooq.meta.jaxb.ForcedType;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.tools.jdbc.JDBCUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class JPADatabase
extends H2Database {
    static final String HIBERNATE_DIALECT = SQLDialect.H2.thirdParty().hibernateDialect();
    static final JooqLogger log = JooqLogger.getLogger(JPADatabase.class);
    private Connection connection;

    public void close() {
        JDBCUtils.safeClose((Connection)this.connection);
        super.close();
    }

    protected DSLContext create0() {
        if (this.connection == null) {
            String packages = this.getProperties().getProperty("packages");
            if (StringUtils.isBlank((String)packages)) {
                packages = "";
                log.warn((Object)"No packages defined", (Object)"It is highly recommended that you provide explicit packages to scan");
            }
            boolean useAttributeConverters = Boolean.valueOf(this.getProperties().getProperty("use-attribute-converters", "true"));
            try {
                Properties info = new Properties();
                info.put("user", "sa");
                info.put("password", "");
                this.connection = new Driver().connect("jdbc:h2:mem:jooq-meta-extensions-" + UUID.randomUUID(), info);
                MetadataSources metadata = new MetadataSources((ServiceRegistry)new StandardServiceRegistryBuilder().applySetting("hibernate.dialect", (Object)HIBERNATE_DIALECT).applySetting("javax.persistence.schema-generation-connection", (Object)this.connection).applySetting("javax.persistence.create-database-schemas", (Object)true).applySetting("hibernate.connection.provider_class", (Object)this.connectionProvider()).build());
                ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(true);
                scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Entity.class));
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                for (String pkg : packages.split(",")) {
                    for (BeanDefinition def : scanner.findCandidateComponents(StringUtils.defaultIfBlank((String)pkg, (String)"").trim())) {
                        metadata.addAnnotatedClass(Class.forName(def.getBeanClassName(), true, cl));
                    }
                }
                SchemaExport export = new SchemaExport();
                export.create(EnumSet.of(TargetType.DATABASE), metadata.buildMetadata());
                if (useAttributeConverters) {
                    this.loadAttributeConverters(metadata.getAnnotatedClasses());
                }
            }
            catch (Exception e) {
                throw new DataAccessException("Error while exporting schema", (Throwable)e);
            }
        }
        return DSL.using((Connection)this.connection);
    }

    ConnectionProvider connectionProvider() {
        return new ConnectionProvider(){

            public boolean isUnwrappableAs(Class unwrapType) {
                return false;
            }

            public <T> T unwrap(Class<T> unwrapType) {
                return null;
            }

            public Connection getConnection() {
                return JPADatabase.this.connection;
            }

            public void closeConnection(Connection conn) {
            }

            public boolean supportsAggressiveRelease() {
                return true;
            }
        };
    }

    private final void loadAttributeConverters(Collection<? extends Class<?>> classes) {
        try {
            AttributeConverterExtractor extractor = new AttributeConverterExtractor(this, classes);
            for (Map.Entry<Name, AttributeConverter<?, ?>> entry : extractor.extract().entrySet()) {
                Class<?> convertToEntityAttribute = null;
                for (Method method : entry.getValue().getClass().getMethods()) {
                    if (!"convertToEntityAttribute".equals(method.getName())) continue;
                    convertToEntityAttribute = method.getReturnType();
                }
                if (convertToEntityAttribute == null) {
                    log.info((Object)"AttributeConverter", (Object)("Cannot use AttributeConverter: " + entry.getValue().getClass().getName()));
                    continue;
                }
                String regex = "(.*?\\.)?" + entry.getKey().unquotedName().toString().replace(".", "\\.");
                ForcedType forcedType = new ForcedType().withExpression("(?i:" + regex + ")").withUserType(convertToEntityAttribute.getName()).withConverter(String.format("new %s(%s.class)", JPAConverter.class.getName(), entry.getValue().getClass().getName()));
                log.info((Object)"AttributeConverter", (Object)("Configuring JPA AttributeConverter: " + forcedType));
                this.getConfiguredForcedTypes().add(forcedType);
            }
        }
        catch (NoClassDefFoundError e) {
            log.info((Object)"AttributeConverter", (Object)("Cannot load AttributeConverters: " + e.getMessage()));
        }
    }

    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>(super.getSchemata0());
        Iterator it = result.iterator();
        while (it.hasNext()) {
            if (!"INFORMATION_SCHEMA".equals(((SchemaDefinition)it.next()).getName())) continue;
            it.remove();
        }
        return result;
    }
}

