/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.extensions.ddl;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2.Driver;
import org.jooq.CreateSchemaFinalStep;
import org.jooq.DSLContext;
import org.jooq.Name;
import org.jooq.Queries;
import org.jooq.Query;
import org.jooq.QueryPart;
import org.jooq.VisitContext;
import org.jooq.VisitListener;
import org.jooq.conf.ParseUnknownFunctions;
import org.jooq.conf.Settings;
import org.jooq.conf.SettingsTools;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultVisitListener;
import org.jooq.impl.ParserException;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.h2.H2Database;
import org.jooq.meta.tools.FilePattern;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.tools.jdbc.JDBCUtils;

public class DDLDatabase
extends H2Database {
    private static final JooqLogger log = JooqLogger.getLogger(DDLDatabase.class);
    private static final Pattern P_NAME = Pattern.compile("(?s:.*?\"([^\"]*)\".*)");
    private Connection connection;
    private DSLContext ctx;
    private boolean publicIsDefault;

    protected DSLContext create0() {
        if (this.connection == null) {
            Settings defaultSettings = new Settings();
            String scripts = this.getProperties().getProperty("scripts");
            String encoding = this.getProperties().getProperty("encoding", "UTF-8");
            String sort = this.getProperties().getProperty("sort", "semantic").toLowerCase();
            String unqualifiedSchema = this.getProperties().getProperty("unqualifiedSchema", "none").toLowerCase();
            final String defaultNameCase = this.getProperties().getProperty("defaultNameCase", "as_is").toUpperCase();
            boolean parseIgnoreComments = !"false".equalsIgnoreCase(this.getProperties().getProperty("parseIgnoreComments"));
            String parseIgnoreCommentStart = this.getProperties().getProperty("parseIgnoreCommentStart", defaultSettings.getParseIgnoreCommentStart());
            String parseIgnoreCommentStop = this.getProperties().getProperty("parseIgnoreCommentStop", defaultSettings.getParseIgnoreCommentStop());
            this.publicIsDefault = "none".equals(unqualifiedSchema);
            Comparator fileComparator = FilePattern.fileComparator((String)sort);
            if (StringUtils.isBlank((String)scripts)) {
                scripts = "";
                log.warn((Object)"No scripts defined", (Object)"It is recommended that you provide an explicit script directory to scan");
            }
            try {
                Properties info = new Properties();
                info.put("user", "sa");
                info.put("password", "");
                this.connection = new Driver().connect("jdbc:h2:mem:jooq-meta-extensions-" + UUID.randomUUID(), info);
                this.ctx = DSL.using((Connection)this.connection, (Settings)new Settings().withParseIgnoreComments(Boolean.valueOf(parseIgnoreComments)).withParseIgnoreCommentStart(parseIgnoreCommentStart).withParseIgnoreCommentStop(parseIgnoreCommentStop).withParseUnknownFunctions(ParseUnknownFunctions.IGNORE));
                this.ctx.data((Object)"org.jooq.ddl.ignore-storage-clauses", (Object)true);
                this.ctx.data((Object)"org.jooq.ddl.parse-for-ddldatabase", (Object)true);
                if (!"AS_IS".equals(defaultNameCase)) {
                    this.ctx.configuration().set(new VisitListener[]{new DefaultVisitListener(){

                        public void visitStart(VisitContext c) {
                            if (c.queryPart() instanceof Name) {
                                Name[] parts = ((Name)c.queryPart()).parts();
                                boolean changed = false;
                                for (int i = 0; i < parts.length; ++i) {
                                    if (parts[i].quoted() != Name.Quoted.UNQUOTED) continue;
                                    parts[i] = DSL.quotedName((String)("UPPER".equals(defaultNameCase) ? parts[i].first().toUpperCase(SettingsTools.renderLocale((Settings)DDLDatabase.this.ctx.settings())) : parts[i].first().toLowerCase(SettingsTools.renderLocale((Settings)DDLDatabase.this.ctx.settings()))));
                                    changed = true;
                                }
                                if (changed) {
                                    c.queryPart((QueryPart)DSL.name((Name[])parts));
                                }
                            }
                        }
                    }});
                }
                FilePattern.load((String)encoding, (String)scripts, (Comparator)fileComparator, (FilePattern.Loader)new FilePattern.Loader(){

                    public void load(String e, InputStream in) {
                        DDLDatabase.this.load(e, in);
                    }
                });
            }
            catch (ParserException e) {
                log.error((Object)("An exception occurred while parsing script source : " + scripts + ". Please report this error to https://github.com/jOOQ/jOOQ/issues/new"), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                throw new DataAccessException("Error while exporting schema", (Throwable)e);
            }
        }
        return DSL.using((Connection)this.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void load(String encoding, InputStream in) {
        try {
            Scanner s = new Scanner(in, encoding).useDelimiter("\\A");
            Queries queries = this.ctx.parser().parse(s.hasNext() ? s.next() : "");
            Iterator iterator = queries.iterator();
            block9: while (iterator.hasNext()) {
                Query query = (Query)iterator.next();
                while (true) {
                    try {
                        query.execute();
                        log.info((Object)query);
                        continue block9;
                    }
                    catch (DataAccessException e) {
                        if (!Integer.toString(90079).equals(e.sqlState())) throw e;
                        SQLException cause = (SQLException)e.getCause(SQLException.class);
                        if (cause == null) throw e;
                        Matcher m = P_NAME.matcher(cause.getMessage());
                        if (!m.find()) throw e;
                        CreateSchemaFinalStep createSchema = this.ctx.createSchemaIfNotExists(DSL.name((String)m.group(1)));
                        createSchema.execute();
                        log.info((Object)createSchema);
                        continue;
                    }
                    break;
                }
            }
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void close() {
        JDBCUtils.safeClose((Connection)this.connection);
        this.connection = null;
        this.ctx = null;
        super.close();
    }

    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>(super.getSchemata0());
        Iterator it = result.iterator();
        while (it.hasNext()) {
            if (!"INFORMATION_SCHEMA".equals(((SchemaDefinition)it.next()).getName())) continue;
            it.remove();
        }
        return result;
    }

    @Deprecated
    public String getOutputSchema(String inputSchema) {
        String outputSchema = super.getOutputSchema(inputSchema);
        if (this.publicIsDefault && "PUBLIC".equals(outputSchema)) {
            return "";
        }
        return outputSchema;
    }

    public String getOutputSchema(String inputCatalog, String inputSchema) {
        String outputSchema = super.getOutputSchema(inputCatalog, inputSchema);
        if (this.publicIsDefault && "PUBLIC".equals(outputSchema)) {
            return "";
        }
        return outputSchema;
    }
}

