/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.h2;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record4;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SortOrder;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractIndexDefinition;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultCheckConstraintDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultEnumDefinition;
import org.jooq.meta.DefaultIndexColumnDefinition;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DefaultSequenceDefinition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.IndexColumnDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.h2.H2RoutineDefinition;
import org.jooq.meta.h2.H2TableDefinition;
import org.jooq.meta.h2.information_schema.tables.Columns;
import org.jooq.meta.h2.information_schema.tables.Constraints;
import org.jooq.meta.h2.information_schema.tables.CrossReferences;
import org.jooq.meta.h2.information_schema.tables.Domains;
import org.jooq.meta.h2.information_schema.tables.FunctionAliases;
import org.jooq.meta.h2.information_schema.tables.Indexes;
import org.jooq.meta.h2.information_schema.tables.Schemata;
import org.jooq.meta.h2.information_schema.tables.Sequences;
import org.jooq.meta.h2.information_schema.tables.Tables;
import org.jooq.meta.h2.information_schema.tables.TypeInfo;
import org.jooq.tools.csv.CSVReader;
import org.jooq.util.h2.H2DataType;

public class H2Database
extends AbstractDatabase {
    private static Boolean is1_4_197;
    private static Boolean is1_4_198;

    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.H2);
    }

    @Override
    protected boolean exists0(TableField<?, ?> field) {
        return this.exists1(field, Columns.COLUMNS, Columns.TABLE_SCHEMA, Columns.TABLE_NAME, Columns.COLUMN_NAME);
    }

    @Override
    protected boolean exists0(Table<?> table) {
        return this.exists1(table, Tables.TABLES, Tables.TABLE_SCHEMA, Tables.TABLE_NAME);
    }

    @Override
    protected List<IndexDefinition> getIndexes0() throws SQLException {
        ArrayList<IndexDefinition> result = new ArrayList<IndexDefinition>();
        Map indexes = this.create().select(Indexes.TABLE_SCHEMA, Indexes.TABLE_NAME, Indexes.INDEX_NAME, Indexes.NON_UNIQUE, Indexes.COLUMN_NAME, Indexes.ORDINAL_POSITION, Indexes.ASC_OR_DESC).from((TableLike)Indexes.INDEXES).where(Indexes.TABLE_SCHEMA.in(this.getInputSchemata())).orderBy(Indexes.TABLE_SCHEMA, Indexes.TABLE_NAME, Indexes.INDEX_NAME, Indexes.ORDINAL_POSITION).fetchGroups(new Field[]{Indexes.TABLE_SCHEMA, Indexes.TABLE_NAME, Indexes.INDEX_NAME, Indexes.NON_UNIQUE}, new Field[]{Indexes.COLUMN_NAME, Indexes.ORDINAL_POSITION});
        block0: for (Map.Entry entry : indexes.entrySet()) {
            Record index = (Record)entry.getKey();
            final Result columns = (Result)entry.getValue();
            SchemaDefinition tableSchema = this.getSchema((String)index.get(Indexes.TABLE_SCHEMA));
            if (tableSchema == null) continue;
            String indexName = (String)index.get(Indexes.INDEX_NAME);
            String tableName = (String)index.get(Indexes.TABLE_NAME);
            final TableDefinition table = this.getTable(tableSchema, tableName);
            if (table == null) continue;
            boolean unique = (Boolean)index.get(Indexes.NON_UNIQUE, Boolean.TYPE) == false;
            for (Record column : columns) {
                if (table.getColumn((String)column.get(Indexes.COLUMN_NAME)) != null) continue;
                continue block0;
            }
            result.add(new AbstractIndexDefinition(tableSchema, indexName, table, unique){
                List<IndexColumnDefinition> indexColumns;
                {
                    super(schema, name, table2, unique);
                    this.indexColumns = new ArrayList<IndexColumnDefinition>();
                    for (Record column : columns) {
                        this.indexColumns.add(new DefaultIndexColumnDefinition(this, table.getColumn((String)column.get(Indexes.COLUMN_NAME)), SortOrder.ASC, (Integer)column.get(Indexes.ORDINAL_POSITION, Integer.TYPE)));
                    }
                }

                @Override
                protected List<IndexColumnDefinition> getIndexColumns0() {
                    return this.indexColumns;
                }
            });
        }
        return result;
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("PRIMARY KEY", "PRIMARY_KEY")) {
            SchemaDefinition schema = this.getSchema((String)record.get(Constraints.TABLE_SCHEMA));
            if (schema == null) continue;
            String tableName = (String)record.get(Constraints.TABLE_NAME);
            String primaryKey = (String)record.get(Constraints.CONSTRAINT_NAME);
            String columnName = (String)record.get(Indexes.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(primaryKey, table, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("UNIQUE")) {
            SchemaDefinition schema = this.getSchema((String)record.get(Constraints.TABLE_SCHEMA));
            if (schema == null) continue;
            String tableName = (String)record.get(Constraints.TABLE_NAME);
            String primaryKey = (String)record.get(Constraints.CONSTRAINT_NAME);
            String columnName = (String)record.get(Indexes.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addUniqueKey(primaryKey, table, table.getColumn(columnName));
        }
    }

    private Result<Record4<String, String, String, String>> fetchKeys(String ... constraintTypes) {
        return this.create().select(Constraints.TABLE_SCHEMA, Constraints.TABLE_NAME, Constraints.CONSTRAINT_NAME, Indexes.COLUMN_NAME).from((TableLike)Constraints.CONSTRAINTS).join((TableLike)Indexes.INDEXES).on(Constraints.TABLE_SCHEMA.eq(Indexes.TABLE_SCHEMA)).and(Constraints.TABLE_NAME.eq(Indexes.TABLE_NAME)).and(Constraints.UNIQUE_INDEX_NAME.eq(Indexes.INDEX_NAME)).where(Constraints.TABLE_SCHEMA.in(this.getInputSchemata())).and(Constraints.CONSTRAINT_TYPE.in((Object[])constraintTypes)).orderBy(Constraints.TABLE_SCHEMA, Constraints.CONSTRAINT_NAME, Indexes.ORDINAL_POSITION).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.create().select(CrossReferences.FK_NAME, CrossReferences.FKTABLE_NAME, CrossReferences.FKTABLE_SCHEMA, CrossReferences.FKCOLUMN_NAME, Constraints.CONSTRAINT_NAME, Constraints.TABLE_NAME, Constraints.CONSTRAINT_SCHEMA).from((TableLike)CrossReferences.CROSS_REFERENCES).join((TableLike)Constraints.CONSTRAINTS).on(CrossReferences.PK_NAME.equal(Constraints.UNIQUE_INDEX_NAME)).and(CrossReferences.PKTABLE_NAME.equal(Constraints.TABLE_NAME)).and(CrossReferences.PKTABLE_SCHEMA.equal(Constraints.TABLE_SCHEMA)).where(CrossReferences.FKTABLE_SCHEMA.in(this.getInputSchemata())).and(Constraints.CONSTRAINT_TYPE.in((Object[])new String[]{"PRIMARY KEY", "PRIMARY_KEY", "UNIQUE"})).orderBy((OrderField)CrossReferences.FKTABLE_SCHEMA.asc(), (OrderField)CrossReferences.FK_NAME.asc(), (OrderField)CrossReferences.ORDINAL_POSITION.asc()).fetch()) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.get(CrossReferences.FKTABLE_SCHEMA));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.get(Constraints.CONSTRAINT_SCHEMA));
            if (foreignKeySchema == null || uniqueKeySchema == null) continue;
            String foreignKey = (String)record.get(CrossReferences.FK_NAME);
            String foreignKeyTableName = (String)record.get(CrossReferences.FKTABLE_NAME);
            String foreignKeyColumn = (String)record.get(CrossReferences.FKCOLUMN_NAME);
            String uniqueKey = (String)record.get(Constraints.CONSTRAINT_NAME);
            String uniqueKeyTableName = (String)record.get(Constraints.TABLE_NAME);
            TableDefinition foreignKeyTable = this.getTable(foreignKeySchema, foreignKeyTableName);
            TableDefinition uniqueKeyTable = this.getTable(uniqueKeySchema, uniqueKeyTableName);
            if (foreignKeyTable == null || uniqueKeyTable == null) continue;
            relations2.addForeignKey(foreignKey, foreignKeyTable, foreignKeyTable.getColumn(foreignKeyColumn), uniqueKey, uniqueKeyTable);
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations relations2) throws SQLException {
        for (Record record : this.create().select(Constraints.TABLE_SCHEMA, Constraints.TABLE_NAME, Constraints.CONSTRAINT_NAME, Constraints.CHECK_EXPRESSION).from((TableLike)Constraints.CONSTRAINTS).where(Constraints.CONSTRAINT_TYPE.eq((Object)"CHECK")).and(Constraints.TABLE_SCHEMA.in(this.getInputSchemata())).union((Select)DSL.select(Columns.TABLE_SCHEMA, Columns.TABLE_NAME, Columns.CHECK_CONSTRAINT, Columns.CHECK_CONSTRAINT).from((TableLike)Columns.COLUMNS).where(Columns.CHECK_CONSTRAINT.nvl((Object)"").ne((Object)"")).and(Columns.TABLE_SCHEMA.in(this.getInputSchemata()))).fetch()) {
            TableDefinition table;
            SchemaDefinition schema = this.getSchema((String)record.get(Constraints.TABLE_SCHEMA));
            if (schema == null || (table = this.getTable(schema, (String)record.get(Constraints.TABLE_NAME))) == null) continue;
            relations2.addCheckConstraint(table, new DefaultCheckConstraintDefinition(schema, table, (String)record.get(Constraints.CONSTRAINT_NAME), (String)record.get(Constraints.CHECK_EXPRESSION)));
        }
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        result.add(new CatalogDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (Record record : this.create().select(Schemata.SCHEMA_NAME, Schemata.REMARKS).from((TableLike)Schemata.SCHEMATA).fetch()) {
            result.add(new SchemaDefinition((Database)this, (String)record.get(Schemata.SCHEMA_NAME), (String)record.get(Schemata.REMARKS)));
        }
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.create().select(Sequences.SEQUENCE_SCHEMA, Sequences.SEQUENCE_NAME).from((TableLike)Sequences.SEQUENCES).where(Sequences.SEQUENCE_SCHEMA.in(this.getInputSchemata())).and(Sequences.SEQUENCE_NAME.upper().notLike("SYSTEM!_SEQUENCE!_%", '!')).orderBy(Sequences.SEQUENCE_SCHEMA, Sequences.SEQUENCE_NAME).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.get(Sequences.SEQUENCE_SCHEMA));
            if (schema == null) continue;
            String name = (String)record.get(Sequences.SEQUENCE_NAME);
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, H2DataType.BIGINT.getTypeName());
            result.add(new DefaultSequenceDefinition(schema, name, type));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(Tables.TABLE_SCHEMA, Tables.TABLE_NAME, Tables.REMARKS).from((TableLike)Tables.TABLES).where(Tables.TABLE_SCHEMA.in(this.getInputSchemata())).orderBy(Tables.TABLE_SCHEMA, Tables.TABLE_NAME).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.TABLE_SCHEMA));
            if (schema == null) continue;
            String name = (String)record.get(Tables.TABLE_NAME);
            String comment = (String)record.get(Tables.REMARKS);
            H2TableDefinition table = new H2TableDefinition(schema, name, comment);
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        Field overloaded = DSL.field((Select)DSL.select((SelectField)DSL.field((Condition)DSL.exists((Select)DSL.select((SelectField)DSL.one()).from((TableLike)FunctionAliases.FUNCTION_ALIASES.as("a")).where(DSL.field((Name)DSL.name((String[])new String[]{"a", FunctionAliases.ALIAS_SCHEMA.getName()})).eq(FunctionAliases.ALIAS_SCHEMA)).and(DSL.field((Name)DSL.name((String[])new String[]{"a", FunctionAliases.ALIAS_NAME.getName()})).eq(FunctionAliases.ALIAS_NAME)).and(DSL.field((Name)DSL.name((String[])new String[]{"a", FunctionAliases.COLUMN_COUNT.getName()})).ne(FunctionAliases.COLUMN_COUNT)))))).as("overloaded");
        for (Record record : this.create().select(FunctionAliases.ALIAS_SCHEMA, FunctionAliases.ALIAS_NAME, FunctionAliases.REMARKS, FunctionAliases.DATA_TYPE, FunctionAliases.RETURNS_RESULT, FunctionAliases.COLUMN_COUNT, (SelectField)overloaded, TypeInfo.TYPE_NAME, TypeInfo.PRECISION, TypeInfo.MAXIMUM_SCALE).from((TableLike)FunctionAliases.FUNCTION_ALIASES).leftOuterJoin((TableLike)TypeInfo.TYPE_INFO).on(FunctionAliases.DATA_TYPE.equal(TypeInfo.DATA_TYPE)).and(TypeInfo.POS.equal((Object)0)).where(FunctionAliases.ALIAS_SCHEMA.in(this.getInputSchemata())).and(FunctionAliases.RETURNS_RESULT.in((Object[])new Short[]{(short)1, (short)2})).orderBy(FunctionAliases.ALIAS_NAME).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.get(FunctionAliases.ALIAS_SCHEMA));
            if (schema == null) continue;
            String name = (String)record.get(FunctionAliases.ALIAS_NAME);
            String comment = (String)record.get(FunctionAliases.REMARKS);
            String typeName = (String)record.get(TypeInfo.TYPE_NAME);
            Integer precision = (Integer)record.get(TypeInfo.PRECISION);
            Short scale = (Short)record.get(TypeInfo.MAXIMUM_SCALE);
            String overload = (Boolean)record.get(overloaded) != false ? (String)record.get(FunctionAliases.COLUMN_COUNT, String.class) : null;
            result.add(new H2RoutineDefinition(schema, name, comment, typeName, precision, scale, overload));
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        if (!this.is1_4_197()) {
            return result;
        }
        this.getInlineEnums(result);
        this.getDomainEnums(result);
        return result;
    }

    private void getInlineEnums(List<EnumDefinition> result) {
        for (Record record : this.create().select(Columns.TABLE_SCHEMA, Columns.TABLE_NAME, Columns.COLUMN_NAME, Columns.COLUMN_TYPE).from((TableLike)Columns.COLUMNS).where(Columns.COLUMN_TYPE.like("ENUM(%)%").and(Columns.TABLE_SCHEMA.in(this.getInputSchemata()))).orderBy((OrderField)Columns.TABLE_SCHEMA.asc(), (OrderField)Columns.TABLE_NAME.asc(), (OrderField)Columns.COLUMN_NAME.asc())) {
            ColumnDefinition columnDefinition;
            SchemaDefinition schema = this.getSchema((String)record.get(Columns.TABLE_SCHEMA));
            if (schema == null) continue;
            String table = (String)record.get(Columns.TABLE_NAME);
            String column = (String)record.get(Columns.COLUMN_NAME);
            String name = table + "_" + column;
            String columnType = (String)record.get(Columns.COLUMN_TYPE);
            TableDefinition tableDefinition = this.getTable(schema, table);
            if (tableDefinition == null || (columnDefinition = tableDefinition.getColumn(column)) == null || this.getConfiguredForcedType(columnDefinition, columnDefinition.getType()) != null) continue;
            DefaultEnumDefinition definition = new DefaultEnumDefinition(schema, name, "");
            CSVReader reader = new CSVReader((Reader)new StringReader(columnType.replaceAll("(^enum\\()|(\\).*$)", "")), ',', '\'', true);
            for (String string : reader.next()) {
                definition.addLiteral(string);
            }
            result.add(definition);
        }
    }

    private void getDomainEnums(List<EnumDefinition> result) {
        for (Record record : this.create().select(Domains.DOMAIN_SCHEMA, Domains.DOMAIN_NAME, Domains.SQL).from((TableLike)Domains.DOMAINS).where(Domains.TYPE_NAME.eq((Field)DSL.inline((String)"ENUM"))).and(Domains.DOMAIN_SCHEMA.in(this.getInputSchemata())).orderBy(Domains.DOMAIN_SCHEMA, Domains.DOMAIN_NAME)) {
            SchemaDefinition schema = this.getSchema((String)record.get(Domains.DOMAIN_SCHEMA));
            if (schema == null) continue;
            String name = (String)record.get(Domains.DOMAIN_NAME);
            String sql = (String)record.get(Domains.SQL);
            DefaultEnumDefinition definition = new DefaultEnumDefinition(schema, name, "");
            CSVReader reader = new CSVReader((Reader)new StringReader(sql.replaceAll("(?i:(^.*as enum\\()|(\\).*$))", "")), ',', '\'', true);
            for (String string : reader.next()) {
                definition.addLiteral(string);
            }
            result.add(definition);
        }
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    boolean is1_4_197() {
        if (is1_4_197 == null) {
            is1_4_197 = this.exists(Columns.COLUMN_TYPE);
        }
        return is1_4_197;
    }

    boolean is1_4_198() {
        if (is1_4_198 == null) {
            is1_4_198 = this.exists(Columns.IS_VISIBLE);
        }
        return is1_4_198;
    }
}

