/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.mysql;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jooq.Record;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractTableDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DefaultColumnDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.mysql.information_schema.tables.Columns;

public class MySQLTableDefinition
extends AbstractTableDefinition {
    private static final Pattern COLUMN_TYPE = Pattern.compile("(\\w+)\\s*(\\(\\d+\\))?\\s*(unsigned)?");

    public MySQLTableDefinition(SchemaDefinition schema, String name, String comment) {
        super(schema, name, comment);
    }

    @Override
    public List<ColumnDefinition> getElements0() throws SQLException {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        for (Record record : this.create().select(Columns.ORDINAL_POSITION, Columns.COLUMN_NAME, Columns.COLUMN_COMMENT, Columns.COLUMN_TYPE, Columns.DATA_TYPE, Columns.IS_NULLABLE, Columns.COLUMN_DEFAULT, Columns.CHARACTER_MAXIMUM_LENGTH, Columns.NUMERIC_PRECISION, Columns.NUMERIC_SCALE, Columns.EXTRA).from((TableLike)Columns.COLUMNS).where(Columns.TABLE_SCHEMA.in((Object[])new String[]{this.getSchema().getName(), this.getSchema().getName()})).and(Columns.TABLE_NAME.equal((Object)this.getName())).orderBy(Columns.ORDINAL_POSITION)) {
            Matcher matcher;
            String dataType = (String)record.get(Columns.DATA_TYPE);
            boolean unsigned = this.getDatabase().supportsUnsignedTypes();
            boolean displayWidths = this.getDatabase().integerDisplayWidths();
            if ((unsigned || displayWidths) && Arrays.asList("tinyint", "smallint", "mediumint", "int", "bigint").contains(dataType.toLowerCase()) && (matcher = COLUMN_TYPE.matcher(((String)record.get(Columns.COLUMN_TYPE)).toLowerCase())).find()) {
                String mType = matcher.group(1);
                String mPrecision = matcher.group(2);
                String mUnsigned = matcher.group(3);
                dataType = mType + (unsigned && mUnsigned != null ? mUnsigned : "") + (displayWidths && mPrecision != null ? mPrecision : "");
            }
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), dataType, (Number)record.get(Columns.CHARACTER_MAXIMUM_LENGTH), (Number)record.get(Columns.NUMERIC_PRECISION), (Number)record.get(Columns.NUMERIC_SCALE), (Boolean)record.get(Columns.IS_NULLABLE, Boolean.TYPE), (String)record.get(Columns.COLUMN_DEFAULT), DSL.name((String[])new String[]{this.getSchema().getName(), this.getName() + "_" + (String)record.get(Columns.COLUMN_NAME)}));
            DefaultColumnDefinition column = new DefaultColumnDefinition(this.getDatabase().getTable(this.getSchema(), this.getName()), (String)record.get(Columns.COLUMN_NAME), (Integer)record.get(Columns.ORDINAL_POSITION, Integer.TYPE), type, "auto_increment".equalsIgnoreCase((String)record.get(Columns.EXTRA)), (String)record.get(Columns.COLUMN_COMMENT));
            result.add(column);
        }
        return result;
    }
}

