
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "interval"
})
@XmlRootElement(name = "DiscretizeBin", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "binValue",
    "extensions",
    "interval"
})
public class DiscretizeBin
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<DiscretizeBin>
{

    @XmlAttribute(name = "binValue", required = true)
    @JsonProperty("binValue")
    private String binValue;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Interval", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("Interval")
    private Interval interval;
    private final static long serialVersionUID = 67305485L;

    public DiscretizeBin() {
    }

    public DiscretizeBin(
        @org.jpmml.model.annotations.Property("binValue")
        String binValue,
        @org.jpmml.model.annotations.Property("interval")
        Interval interval) {
        this.binValue = binValue;
        this.interval = interval;
    }

    public String getBinValue() {
        return binValue;
    }

    public DiscretizeBin setBinValue(
        @org.jpmml.model.annotations.Property("binValue")
        String binValue) {
        this.binValue = binValue;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public DiscretizeBin addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Interval getInterval() {
        return interval;
    }

    public DiscretizeBin setInterval(
        @org.jpmml.model.annotations.Property("interval")
        Interval interval) {
        this.interval = interval;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getInterval());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
