
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.adapters.FieldNameAdapter;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "confusionMatrix",
    "liftDatas",
    "roc"
})
@XmlRootElement(name = "PredictiveModelQuality", namespace = "http://www.dmg.org/PMML-4_3")
@org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "targetField",
    "dataName",
    "dataUsage",
    "meanError",
    "meanAbsoluteError",
    "meanSquaredError",
    "rootMeanSquaredError",
    "rSquared",
    "adjRSquared",
    "sumSquaredError",
    "sumSquaredRegression",
    "numOfRecords",
    "numOfRecordsWeighted",
    "numOfPredictors",
    "degreesOfFreedom",
    "fStatistic",
    "aic",
    "bic",
    "aiCc",
    "extensions",
    "confusionMatrix",
    "liftDatas",
    "roc"
})
public class PredictiveModelQuality
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<PredictiveModelQuality>
{

    @XmlAttribute(name = "targetField", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("targetField")
    private FieldName targetField;
    @XmlAttribute(name = "dataName")
    @JsonProperty("dataName")
    private String dataName;
    @XmlAttribute(name = "dataUsage")
    @JsonProperty("dataUsage")
    private PredictiveModelQuality.DataUsage dataUsage;
    @XmlAttribute(name = "meanError")
    @JsonProperty("meanError")
    private Double meanError;
    @XmlAttribute(name = "meanAbsoluteError")
    @JsonProperty("meanAbsoluteError")
    private Double meanAbsoluteError;
    @XmlAttribute(name = "meanSquaredError")
    @JsonProperty("meanSquaredError")
    private Double meanSquaredError;
    @XmlAttribute(name = "rootMeanSquaredError")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("rootMeanSquaredError")
    private Double rootMeanSquaredError;
    @XmlAttribute(name = "r-squared")
    @JsonProperty("r-squared")
    private Double rSquared;
    @XmlAttribute(name = "adj-r-squared")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("adj-r-squared")
    private Double adjRSquared;
    @XmlAttribute(name = "sumSquaredError")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("sumSquaredError")
    private Double sumSquaredError;
    @XmlAttribute(name = "sumSquaredRegression")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("sumSquaredRegression")
    private Double sumSquaredRegression;
    @XmlAttribute(name = "numOfRecords")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("numOfRecords")
    private Double numOfRecords;
    @XmlAttribute(name = "numOfRecordsWeighted")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("numOfRecordsWeighted")
    private Double numOfRecordsWeighted;
    @XmlAttribute(name = "numOfPredictors")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("numOfPredictors")
    private Double numOfPredictors;
    @XmlAttribute(name = "degreesOfFreedom")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("degreesOfFreedom")
    private Double degreesOfFreedom;
    @XmlAttribute(name = "fStatistic")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("fStatistic")
    private Double fStatistic;
    @XmlAttribute(name = "AIC")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("AIC")
    private Double aic;
    @XmlAttribute(name = "BIC")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("BIC")
    private Double bic;
    @XmlAttribute(name = "AICc")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("AICc")
    private Double aiCc;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "ConfusionMatrix", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("ConfusionMatrix")
    private ConfusionMatrix confusionMatrix;
    @XmlElement(name = "LiftData", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("LiftData")
    private List<LiftData> liftDatas;
    @XmlElement(name = "ROC", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("ROC")
    private ROC roc;
    private final static long serialVersionUID = 67305485L;

    public PredictiveModelQuality() {
    }

    public PredictiveModelQuality(
        @org.jpmml.model.annotations.Property("targetField")
        FieldName targetField) {
        this.targetField = targetField;
    }

    public FieldName getTargetField() {
        return targetField;
    }

    public PredictiveModelQuality setTargetField(
        @org.jpmml.model.annotations.Property("targetField")
        FieldName targetField) {
        this.targetField = targetField;
        return this;
    }

    public String getDataName() {
        return dataName;
    }

    public PredictiveModelQuality setDataName(
        @org.jpmml.model.annotations.Property("dataName")
        String dataName) {
        this.dataName = dataName;
        return this;
    }

    public PredictiveModelQuality.DataUsage getDataUsage() {
        if (dataUsage == null) {
            return PredictiveModelQuality.DataUsage.TRAINING;
        } else {
            return dataUsage;
        }
    }

    public PredictiveModelQuality setDataUsage(
        @org.jpmml.model.annotations.Property("dataUsage")
        PredictiveModelQuality.DataUsage dataUsage) {
        this.dataUsage = dataUsage;
        return this;
    }

    public Double getMeanError() {
        return meanError;
    }

    public PredictiveModelQuality setMeanError(
        @org.jpmml.model.annotations.Property("meanError")
        Double meanError) {
        this.meanError = meanError;
        return this;
    }

    public Double getMeanAbsoluteError() {
        return meanAbsoluteError;
    }

    public PredictiveModelQuality setMeanAbsoluteError(
        @org.jpmml.model.annotations.Property("meanAbsoluteError")
        Double meanAbsoluteError) {
        this.meanAbsoluteError = meanAbsoluteError;
        return this;
    }

    public Double getMeanSquaredError() {
        return meanSquaredError;
    }

    public PredictiveModelQuality setMeanSquaredError(
        @org.jpmml.model.annotations.Property("meanSquaredError")
        Double meanSquaredError) {
        this.meanSquaredError = meanSquaredError;
        return this;
    }

    public Double getRootMeanSquaredError() {
        return rootMeanSquaredError;
    }

    public PredictiveModelQuality setRootMeanSquaredError(
        @org.jpmml.model.annotations.Property("rootMeanSquaredError")
        Double rootMeanSquaredError) {
        this.rootMeanSquaredError = rootMeanSquaredError;
        return this;
    }

    public Double getRSquared() {
        return rSquared;
    }

    public PredictiveModelQuality setRSquared(
        @org.jpmml.model.annotations.Property("rSquared")
        Double rSquared) {
        this.rSquared = rSquared;
        return this;
    }

    public Double getAdjRSquared() {
        return adjRSquared;
    }

    public PredictiveModelQuality setAdjRSquared(
        @org.jpmml.model.annotations.Property("adjRSquared")
        Double adjRSquared) {
        this.adjRSquared = adjRSquared;
        return this;
    }

    public Double getSumSquaredError() {
        return sumSquaredError;
    }

    public PredictiveModelQuality setSumSquaredError(
        @org.jpmml.model.annotations.Property("sumSquaredError")
        Double sumSquaredError) {
        this.sumSquaredError = sumSquaredError;
        return this;
    }

    public Double getSumSquaredRegression() {
        return sumSquaredRegression;
    }

    public PredictiveModelQuality setSumSquaredRegression(
        @org.jpmml.model.annotations.Property("sumSquaredRegression")
        Double sumSquaredRegression) {
        this.sumSquaredRegression = sumSquaredRegression;
        return this;
    }

    public Double getNumOfRecords() {
        return numOfRecords;
    }

    public PredictiveModelQuality setNumOfRecords(
        @org.jpmml.model.annotations.Property("numOfRecords")
        Double numOfRecords) {
        this.numOfRecords = numOfRecords;
        return this;
    }

    public Double getNumOfRecordsWeighted() {
        return numOfRecordsWeighted;
    }

    public PredictiveModelQuality setNumOfRecordsWeighted(
        @org.jpmml.model.annotations.Property("numOfRecordsWeighted")
        Double numOfRecordsWeighted) {
        this.numOfRecordsWeighted = numOfRecordsWeighted;
        return this;
    }

    public Double getNumOfPredictors() {
        return numOfPredictors;
    }

    public PredictiveModelQuality setNumOfPredictors(
        @org.jpmml.model.annotations.Property("numOfPredictors")
        Double numOfPredictors) {
        this.numOfPredictors = numOfPredictors;
        return this;
    }

    public Double getDegreesOfFreedom() {
        return degreesOfFreedom;
    }

    public PredictiveModelQuality setDegreesOfFreedom(
        @org.jpmml.model.annotations.Property("degreesOfFreedom")
        Double degreesOfFreedom) {
        this.degreesOfFreedom = degreesOfFreedom;
        return this;
    }

    public Double getFStatistic() {
        return fStatistic;
    }

    public PredictiveModelQuality setFStatistic(
        @org.jpmml.model.annotations.Property("fStatistic")
        Double fStatistic) {
        this.fStatistic = fStatistic;
        return this;
    }

    public Double getAIC() {
        return aic;
    }

    public PredictiveModelQuality setAIC(
        @org.jpmml.model.annotations.Property("aic")
        Double aic) {
        this.aic = aic;
        return this;
    }

    public Double getBIC() {
        return bic;
    }

    public PredictiveModelQuality setBIC(
        @org.jpmml.model.annotations.Property("bic")
        Double bic) {
        this.bic = bic;
        return this;
    }

    public Double getAICc() {
        return aiCc;
    }

    public PredictiveModelQuality setAICc(
        @org.jpmml.model.annotations.Property("aiCc")
        Double aiCc) {
        this.aiCc = aiCc;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public PredictiveModelQuality addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public ConfusionMatrix getConfusionMatrix() {
        return confusionMatrix;
    }

    public PredictiveModelQuality setConfusionMatrix(
        @org.jpmml.model.annotations.Property("confusionMatrix")
        ConfusionMatrix confusionMatrix) {
        this.confusionMatrix = confusionMatrix;
        return this;
    }

    public boolean hasLiftDatas() {
        return ((this.liftDatas!= null)&&(this.liftDatas.size()> 0));
    }

    public List<LiftData> getLiftDatas() {
        if (liftDatas == null) {
            liftDatas = new ArrayList<LiftData>();
        }
        return this.liftDatas;
    }

    public PredictiveModelQuality addLiftDatas(LiftData... liftDatas) {
        getLiftDatas().addAll(Arrays.asList(liftDatas));
        return this;
    }

    public ROC getROC() {
        return roc;
    }

    public PredictiveModelQuality setROC(
        @org.jpmml.model.annotations.Property("roc")
        ROC roc) {
        this.roc = roc;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getConfusionMatrix());
            }
            if ((status == VisitorAction.CONTINUE)&&hasLiftDatas()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getLiftDatas());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getROC());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum DataUsage
        implements StringValue<PredictiveModelQuality.DataUsage>
    {

        @XmlEnumValue("training")
        @JsonProperty("training")
        TRAINING("training"),
        @XmlEnumValue("test")
        @JsonProperty("test")
        TEST("test"),
        @XmlEnumValue("validation")
        @JsonProperty("validation")
        VALIDATION("validation");
        private final String value;

        DataUsage(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static PredictiveModelQuality.DataUsage fromValue(String v) {
            for (PredictiveModelQuality.DataUsage c: PredictiveModelQuality.DataUsage.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
