
package org.dmg.pmml.sequence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "Constraints", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_3_1))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "minimumNumberOfItems",
    "maximumNumberOfItems",
    "minimumNumberOfAntecedentItems",
    "maximumNumberOfAntecedentItems",
    "minimumNumberOfConsequentItems",
    "maximumNumberOfConsequentItems",
    "minimumSupport",
    "minimumConfidence",
    "minimumLift",
    "minimumTotalSequenceTime",
    "maximumTotalSequenceTime",
    "minimumItemsetSeparationTime",
    "maximumItemsetSeparationTime",
    "minimumAntConsSeparationTime",
    "maximumAntConsSeparationTime",
    "extensions"
})
public class Constraints
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Constraints>
{

    @XmlAttribute(name = "minimumNumberOfItems")
    @JsonProperty("minimumNumberOfItems")
    private Integer minimumNumberOfItems;
    @XmlAttribute(name = "maximumNumberOfItems")
    @JsonProperty("maximumNumberOfItems")
    private Integer maximumNumberOfItems;
    @XmlAttribute(name = "minimumNumberOfAntecedentItems")
    @JsonProperty("minimumNumberOfAntecedentItems")
    private Integer minimumNumberOfAntecedentItems;
    @XmlAttribute(name = "maximumNumberOfAntecedentItems")
    @JsonProperty("maximumNumberOfAntecedentItems")
    private Integer maximumNumberOfAntecedentItems;
    @XmlAttribute(name = "minimumNumberOfConsequentItems")
    @JsonProperty("minimumNumberOfConsequentItems")
    private Integer minimumNumberOfConsequentItems;
    @XmlAttribute(name = "maximumNumberOfConsequentItems")
    @JsonProperty("maximumNumberOfConsequentItems")
    private Integer maximumNumberOfConsequentItems;
    @XmlAttribute(name = "minimumSupport")
    @JsonProperty("minimumSupport")
    private Double minimumSupport;
    @XmlAttribute(name = "minimumConfidence")
    @JsonProperty("minimumConfidence")
    private Double minimumConfidence;
    @XmlAttribute(name = "minimumLift")
    @JsonProperty("minimumLift")
    private Double minimumLift;
    @XmlAttribute(name = "minimumTotalSequenceTime")
    @JsonProperty("minimumTotalSequenceTime")
    private Double minimumTotalSequenceTime;
    @XmlAttribute(name = "maximumTotalSequenceTime")
    @JsonProperty("maximumTotalSequenceTime")
    private Double maximumTotalSequenceTime;
    @XmlAttribute(name = "minimumItemsetSeparationTime")
    @JsonProperty("minimumItemsetSeparationTime")
    private Double minimumItemsetSeparationTime;
    @XmlAttribute(name = "maximumItemsetSeparationTime")
    @JsonProperty("maximumItemsetSeparationTime")
    private Double maximumItemsetSeparationTime;
    @XmlAttribute(name = "minimumAntConsSeparationTime")
    @JsonProperty("minimumAntConsSeparationTime")
    private Double minimumAntConsSeparationTime;
    @XmlAttribute(name = "maximumAntConsSeparationTime")
    @JsonProperty("maximumAntConsSeparationTime")
    private Double maximumAntConsSeparationTime;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static Integer DEFAULT_MINIMUM_NUMBER_OF_ITEMS = 1;
    private final static Integer DEFAULT_MINIMUM_NUMBER_OF_ANTECEDENT_ITEMS = 1;
    private final static Integer DEFAULT_MINIMUM_NUMBER_OF_CONSEQUENT_ITEMS = 1;
    private final static Double DEFAULT_MINIMUM_SUPPORT = 0.0D;
    private final static Double DEFAULT_MINIMUM_CONFIDENCE = 0.0D;
    private final static Double DEFAULT_MINIMUM_LIFT = 0.0D;
    private final static Double DEFAULT_MINIMUM_TOTAL_SEQUENCE_TIME = 0.0D;
    private final static Double DEFAULT_MINIMUM_ITEMSET_SEPARATION_TIME = 0.0D;
    private final static Double DEFAULT_MINIMUM_ANT_CONS_SEPARATION_TIME = 0.0D;
    private final static long serialVersionUID = 67305485L;

    public Integer getMinimumNumberOfItems() {
        if (minimumNumberOfItems == null) {
            return DEFAULT_MINIMUM_NUMBER_OF_ITEMS;
        } else {
            return minimumNumberOfItems;
        }
    }

    public Constraints setMinimumNumberOfItems(
        @Property("minimumNumberOfItems")
        Integer minimumNumberOfItems) {
        this.minimumNumberOfItems = minimumNumberOfItems;
        return this;
    }

    public Integer getMaximumNumberOfItems() {
        return maximumNumberOfItems;
    }

    public Constraints setMaximumNumberOfItems(
        @Property("maximumNumberOfItems")
        Integer maximumNumberOfItems) {
        this.maximumNumberOfItems = maximumNumberOfItems;
        return this;
    }

    public Integer getMinimumNumberOfAntecedentItems() {
        if (minimumNumberOfAntecedentItems == null) {
            return DEFAULT_MINIMUM_NUMBER_OF_ANTECEDENT_ITEMS;
        } else {
            return minimumNumberOfAntecedentItems;
        }
    }

    public Constraints setMinimumNumberOfAntecedentItems(
        @Property("minimumNumberOfAntecedentItems")
        Integer minimumNumberOfAntecedentItems) {
        this.minimumNumberOfAntecedentItems = minimumNumberOfAntecedentItems;
        return this;
    }

    public Integer getMaximumNumberOfAntecedentItems() {
        return maximumNumberOfAntecedentItems;
    }

    public Constraints setMaximumNumberOfAntecedentItems(
        @Property("maximumNumberOfAntecedentItems")
        Integer maximumNumberOfAntecedentItems) {
        this.maximumNumberOfAntecedentItems = maximumNumberOfAntecedentItems;
        return this;
    }

    public Integer getMinimumNumberOfConsequentItems() {
        if (minimumNumberOfConsequentItems == null) {
            return DEFAULT_MINIMUM_NUMBER_OF_CONSEQUENT_ITEMS;
        } else {
            return minimumNumberOfConsequentItems;
        }
    }

    public Constraints setMinimumNumberOfConsequentItems(
        @Property("minimumNumberOfConsequentItems")
        Integer minimumNumberOfConsequentItems) {
        this.minimumNumberOfConsequentItems = minimumNumberOfConsequentItems;
        return this;
    }

    public Integer getMaximumNumberOfConsequentItems() {
        return maximumNumberOfConsequentItems;
    }

    public Constraints setMaximumNumberOfConsequentItems(
        @Property("maximumNumberOfConsequentItems")
        Integer maximumNumberOfConsequentItems) {
        this.maximumNumberOfConsequentItems = maximumNumberOfConsequentItems;
        return this;
    }

    public Double getMinimumSupport() {
        if (minimumSupport == null) {
            return DEFAULT_MINIMUM_SUPPORT;
        } else {
            return minimumSupport;
        }
    }

    public Constraints setMinimumSupport(
        @Property("minimumSupport")
        Double minimumSupport) {
        this.minimumSupport = minimumSupport;
        return this;
    }

    public Double getMinimumConfidence() {
        if (minimumConfidence == null) {
            return DEFAULT_MINIMUM_CONFIDENCE;
        } else {
            return minimumConfidence;
        }
    }

    public Constraints setMinimumConfidence(
        @Property("minimumConfidence")
        Double minimumConfidence) {
        this.minimumConfidence = minimumConfidence;
        return this;
    }

    public Double getMinimumLift() {
        if (minimumLift == null) {
            return DEFAULT_MINIMUM_LIFT;
        } else {
            return minimumLift;
        }
    }

    public Constraints setMinimumLift(
        @Property("minimumLift")
        Double minimumLift) {
        this.minimumLift = minimumLift;
        return this;
    }

    public Double getMinimumTotalSequenceTime() {
        if (minimumTotalSequenceTime == null) {
            return DEFAULT_MINIMUM_TOTAL_SEQUENCE_TIME;
        } else {
            return minimumTotalSequenceTime;
        }
    }

    public Constraints setMinimumTotalSequenceTime(
        @Property("minimumTotalSequenceTime")
        Double minimumTotalSequenceTime) {
        this.minimumTotalSequenceTime = minimumTotalSequenceTime;
        return this;
    }

    public Double getMaximumTotalSequenceTime() {
        return maximumTotalSequenceTime;
    }

    public Constraints setMaximumTotalSequenceTime(
        @Property("maximumTotalSequenceTime")
        Double maximumTotalSequenceTime) {
        this.maximumTotalSequenceTime = maximumTotalSequenceTime;
        return this;
    }

    public Double getMinimumItemsetSeparationTime() {
        if (minimumItemsetSeparationTime == null) {
            return DEFAULT_MINIMUM_ITEMSET_SEPARATION_TIME;
        } else {
            return minimumItemsetSeparationTime;
        }
    }

    public Constraints setMinimumItemsetSeparationTime(
        @Property("minimumItemsetSeparationTime")
        Double minimumItemsetSeparationTime) {
        this.minimumItemsetSeparationTime = minimumItemsetSeparationTime;
        return this;
    }

    public Double getMaximumItemsetSeparationTime() {
        return maximumItemsetSeparationTime;
    }

    public Constraints setMaximumItemsetSeparationTime(
        @Property("maximumItemsetSeparationTime")
        Double maximumItemsetSeparationTime) {
        this.maximumItemsetSeparationTime = maximumItemsetSeparationTime;
        return this;
    }

    public Double getMinimumAntConsSeparationTime() {
        if (minimumAntConsSeparationTime == null) {
            return DEFAULT_MINIMUM_ANT_CONS_SEPARATION_TIME;
        } else {
            return minimumAntConsSeparationTime;
        }
    }

    public Constraints setMinimumAntConsSeparationTime(
        @Property("minimumAntConsSeparationTime")
        Double minimumAntConsSeparationTime) {
        this.minimumAntConsSeparationTime = minimumAntConsSeparationTime;
        return this;
    }

    public Double getMaximumAntConsSeparationTime() {
        return maximumAntConsSeparationTime;
    }

    public Constraints setMaximumAntConsSeparationTime(
        @Property("maximumAntConsSeparationTime")
        Double maximumAntConsSeparationTime) {
        this.maximumAntConsSeparationTime = maximumAntConsSeparationTime;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Constraints addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
