
package org.dmg.pmml.sequence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "Time", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "min",
    "max",
    "mean",
    "standardDeviation",
    "extensions"
})
public class Time
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Time>
{

    @XmlAttribute(name = "min")
    @org.jpmml.model.annotations.Optional((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("min")
    private Double min;
    @XmlAttribute(name = "max")
    @org.jpmml.model.annotations.Optional((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("max")
    private Double max;
    @XmlAttribute(name = "mean")
    @JsonProperty("mean")
    private Double mean;
    @XmlAttribute(name = "standardDeviation")
    @Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("standardDeviation")
    private Double standardDeviation;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67305485L;

    public Double getMin() {
        return min;
    }

    public Time setMin(
        @Property("min")
        Double min) {
        this.min = min;
        return this;
    }

    public Double getMax() {
        return max;
    }

    public Time setMax(
        @Property("max")
        Double max) {
        this.max = max;
        return this;
    }

    public Double getMean() {
        return mean;
    }

    public Time setMean(
        @Property("mean")
        Double mean) {
        this.mean = mean;
        return this;
    }

    public Double getStandardDeviation() {
        return standardDeviation;
    }

    public Time setStandardDeviation(
        @Property("standardDeviation")
        Double standardDeviation) {
        this.standardDeviation = standardDeviation;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Time addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
