/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.main;

import com.headius.options.Option;
import java.io.InputStream;
import org.crac.CheckpointException;
import org.crac.Context;
import org.crac.Core;
import org.crac.Resource;
import org.crac.RestoreException;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.exceptions.RaiseException;
import org.jruby.main.PrebootMain;
import org.jruby.util.cli.Options;

public class CheckpointMain
extends PrebootMain {
    public static void main(String[] args2) {
        CheckpointMain.preboot(new CheckpointMain(), args2);
    }

    @Override
    protected String[] warmup(String[] args2) {
        Ruby ruby = Ruby.newInstance();
        ruby.evalScriptlet("1 + 1");
        Ruby.clearGlobalRuntime();
        return args2;
    }

    @Override
    protected RubyInstanceConfig prepareConfig(String[] args2) {
        RubyInstanceConfig config = super.prepareConfig(args2);
        if (args2.length > 0) {
            config.processArguments(args2);
        }
        return config;
    }

    @Override
    protected Ruby prepareRuntime(RubyInstanceConfig config, String[] args2) {
        Ruby ruby = super.prepareRuntime(config, args2);
        if (args2.length > 0) {
            InputStream in = config.getScriptSource();
            String filename2 = config.displayedFileName();
            try {
                if (in != null && !config.getShouldCheckSyntax()) {
                    ruby.runFromMain(in, filename2);
                }
            }
            catch (RaiseException rj) {
                CheckpointMain.handleRaiseException(rj);
            }
        }
        return ruby;
    }

    @Override
    protected void endPreboot(RubyInstanceConfig config, Ruby ruby, String[] args2) {
        super.endPreboot(config, ruby, args2);
        try {
            Core.getGlobalContext().register((Resource)new JRubyContext());
            Core.checkpointRestore();
        }
        catch (CheckpointException | RestoreException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static class JRubyContext
    extends Context<Resource> {
        private JRubyContext() {
        }

        public void beforeCheckpoint(Context<? extends Resource> context) throws CheckpointException {
        }

        public void afterRestore(Context<? extends Resource> context) throws RestoreException {
            Options.PROPERTIES.forEach(Option::reload);
        }

        public void register(Resource resource) {
        }
    }
}

