/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import com.kenai.constantine.platform.AddressFamily;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import jnr.netdb.Service;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.RubyIPSocket;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;

public class RubyTCPSocket
extends RubyIPSocket {
    private static ObjectAllocator TCPSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyTCPSocket(runtime2, klass);
        }
    };

    static void createTCPSocket(Ruby runtime2) {
        RubyClass rb_cTCPSocket = runtime2.defineClass("TCPSocket", runtime2.fastGetClass("IPSocket"), TCPSOCKET_ALLOCATOR);
        rb_cTCPSocket.includeModule(runtime2.fastGetClass("Socket").fastGetConstant("Constants"));
        rb_cTCPSocket.defineAnnotatedMethods(RubyTCPSocket.class);
        runtime2.getObject().fastSetConstant("TCPsocket", rb_cTCPSocket);
    }

    public RubyTCPSocket(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    private int getPortFrom(Ruby runtime2, IRubyObject arg2) {
        if (arg2 instanceof RubyString) {
            Service service = Service.getServiceByName(arg2.asJavaString(), "tcp");
            return service != null ? service.getPort() : RubyNumeric.fix2int(RubyNumeric.str2inum(runtime2, (RubyString)arg2, 0, true));
        }
        return RubyNumeric.fix2int(arg2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JRubyMethod(required=2, optional=2, visibility=Visibility.PRIVATE, backtrace=true)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        Arity.checkArgumentCount(context.getRuntime(), args2, 2, 4);
        String remoteHost = args2[0].isNil() ? "localhost" : args2[0].convertToString().toString();
        int remotePort = this.getPortFrom(context.getRuntime(), args2[1]);
        String localHost = args2.length >= 3 && !args2[2].isNil() ? args2[2].convertToString().toString() : null;
        int localPort = args2.length == 4 && !args2[3].isNil() ? this.getPortFrom(context.getRuntime(), args2[3]) : 0;
        try {
            SocketChannel channel;
            block12: {
                channel = SocketChannel.open();
                Socket socket2 = channel.socket();
                if (localHost != null) {
                    socket2.bind(new InetSocketAddress(InetAddress.getByName(localHost), localPort));
                }
                boolean success2 = false;
                try {
                    try {
                        channel.configureBlocking(false);
                        channel.connect(new InetSocketAddress(InetAddress.getByName(remoteHost), remotePort));
                        context.getThread().select(channel, this, 8);
                        channel.finishConnect();
                        success2 = true;
                    }
                    catch (NoRouteToHostException nrthe) {
                        throw context.getRuntime().newErrnoEHOSTUNREACHError("SocketChannel.connect");
                    }
                    catch (ConnectException e) {
                        throw context.getRuntime().newErrnoECONNREFUSEDError();
                    }
                    catch (UnknownHostException e) {
                        throw RubyTCPSocket.sockerr(context.getRuntime(), "initialize: name or service not known");
                    }
                    Object var12_14 = null;
                    if (!success2) break block12;
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    if (!success2) throw throwable;
                    channel.configureBlocking(true);
                    throw throwable;
                }
                channel.configureBlocking(true);
            }
            this.initSocket(context.getRuntime(), new ChannelDescriptor((Channel)channel, new ModeFlags(ModeFlags.RDWR)));
            return this;
        }
        catch (InvalidValueException ex) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (ClosedChannelException cce) {
            throw context.getRuntime().newErrnoECONNREFUSEDError();
        }
        catch (IOException e) {
            throw RubyTCPSocket.sockerr(context.getRuntime(), e.getLocalizedMessage());
        }
        catch (IllegalArgumentException iae) {
            throw RubyTCPSocket.sockerr(context.getRuntime(), iae.getMessage());
        }
    }

    @Deprecated
    public static IRubyObject open(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyTCPSocket.open(recv2.getRuntime().getCurrentContext(), recv2, args2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(rest=true, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject iRubyObject;
        block3: {
            RubyTCPSocket sock = (RubyTCPSocket)recv2.callMethod(context, "new", args2);
            if (!block.isGiven()) {
                return sock;
            }
            try {
                iRubyObject = block.yield(context, sock);
                Object var7_6 = null;
                if (!sock.openFile.isOpen()) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var7_7 = null;
                    if (!sock.openFile.isOpen()) break block4;
                    sock.close();
                }
                throw throwable;
            }
            sock.close();
        }
        return iRubyObject;
    }

    @Deprecated
    public static IRubyObject gethostbyname(IRubyObject recv2, IRubyObject hostname) {
        return RubyTCPSocket.gethostbyname(recv2.getRuntime().getCurrentContext(), recv2, hostname);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject gethostbyname(ThreadContext context, IRubyObject recv2, IRubyObject hostname) {
        try {
            IRubyObject[] ret = new IRubyObject[4];
            Ruby r = context.getRuntime();
            String hostString = hostname.convertToString().toString();
            InetAddress addr2 = InetAddress.getByName(hostString);
            ret[0] = r.newString(RubyTCPSocket.do_not_reverse_lookup(recv2).isTrue() ? addr2.getHostAddress() : addr2.getCanonicalHostName());
            ret[1] = r.newArray();
            ret[3] = r.newString(addr2.getHostAddress());
            if (addr2 instanceof Inet4Address) {
                Inet4Address addr4 = (Inet4Address)addr2;
                ret[2] = r.newFixnum(AddressFamily.AF_INET);
            } else if (addr2 instanceof Inet6Address) {
                Inet6Address addr6 = (Inet6Address)addr2;
                ret[2] = r.newFixnum(AddressFamily.AF_INET6);
            }
            return r.newArrayNoCopy(ret);
        }
        catch (UnknownHostException e) {
            throw RubyTCPSocket.sockerr(context.getRuntime(), "gethostbyname: name or service not known");
        }
    }
}

