/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstNode
extends Node
implements INameNode {
    private String name;
    private volatile transient IRubyObject cachedValue = null;
    private int generation = -1;

    public ConstNode(ISourcePosition position, String name2) {
        super(position);
        this.name = name2;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CONSTNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitConstNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject value2 = this.getValue(context);
        return value2 != null ? value2 : context.getCurrentScope().getStaticScope().getModule().callMethod(context, "const_missing", (IRubyObject)runtime2.fastNewSymbol(this.name));
    }

    @Override
    public ByteList definition(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        return context.getConstantDefined(this.name) ? CONSTANT_BYTELIST : null;
    }

    public IRubyObject getValue(ThreadContext context) {
        IRubyObject value2 = this.cachedValue;
        return this.isCached(context, value2) ? value2 : this.reCache(context, this.name);
    }

    private boolean isCached(ThreadContext context, IRubyObject value2) {
        return value2 != null && this.generation == context.getRuntime().getConstantGeneration();
    }

    public IRubyObject reCache(ThreadContext context, String name2) {
        IRubyObject value2;
        int newGeneration = context.getRuntime().getConstantGeneration();
        this.cachedValue = value2 = context.getConstant(name2);
        if (value2 != null) {
            this.generation = newGeneration;
        }
        return value2;
    }
}

