/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockAcceptingNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FCallNode
extends Node
implements INameNode,
IArgumentNode,
BlockAcceptingNode {
    protected Node argsNode;
    protected Node iterNode;
    public CallSite callAdapter;

    @Deprecated
    public FCallNode(ISourcePosition position, String name2, Node argsNode) {
        this(position, name2, argsNode, null);
    }

    protected FCallNode(ISourcePosition position, String name2, Node argsNode, Node iterNode) {
        super(position);
        this.setArgsNode(argsNode);
        this.iterNode = iterNode;
        this.callAdapter = MethodIndex.getFunctionalCallSite(name2);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.FCALLNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitFCallNode(this);
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Node setIterNode(Node iterNode) {
        this.iterNode = iterNode;
        this.callAdapter = MethodIndex.getFunctionalCallSite(this.callAdapter.methodName);
        return this;
    }

    @Override
    public Node getArgsNode() {
        return this.argsNode;
    }

    @Override
    public Node setArgsNode(Node argsNode) {
        this.argsNode = argsNode;
        if (argsNode instanceof ArrayNode) {
            ((ArrayNode)argsNode).setLightweight(true);
        }
        return argsNode;
    }

    @Override
    public String getName() {
        return this.callAdapter.methodName;
    }

    @Override
    public List<Node> childNodes() {
        return FCallNode.createList(this.argsNode, this.iterNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        assert (false) : "Should not happen anymore";
        return null;
    }

    @Override
    public ByteList definition(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        if (self.getMetaClass().isMethodBound(this.getName(), false)) {
            return ASTInterpreter.getArgumentDefinition(runtime2, context, this.getArgsNode(), METHOD_BYTELIST, self, aBlock);
        }
        return null;
    }
}

