/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import com.kenai.constantine.platform.OpenFlags;
import org.jruby.util.io.InvalidValueException;

public class ModeFlags
implements Cloneable {
    public static final int RDONLY = OpenFlags.O_RDONLY.value();
    public static final int WRONLY = OpenFlags.O_WRONLY.value();
    public static final int RDWR = OpenFlags.O_RDWR.value();
    public static final int CREAT = OpenFlags.O_CREAT.value();
    public static final int EXCL = OpenFlags.O_EXCL.value();
    public static final int TRUNC = OpenFlags.O_TRUNC.value();
    public static final int APPEND = OpenFlags.O_APPEND.value();
    public static final int NONBLOCK = OpenFlags.O_NONBLOCK.value();
    public static final int BINARY = OpenFlags.O_BINARY.value();
    public static final int ACCMODE = RDWR | WRONLY | RDONLY;
    private final int flags;

    public ModeFlags() {
        this.flags = RDONLY;
    }

    public ModeFlags(long flags) throws InvalidValueException {
        this.flags = (int)flags;
        if (this.isReadOnly() && (flags & (long)APPEND) != 0L) {
            throw new InvalidValueException();
        }
    }

    public String toJavaModeString() {
        if (this.isWritable() || this.isCreate() || this.isTruncate()) {
            return "rw";
        }
        return "r";
    }

    public boolean isReadOnly() {
        return (this.flags & WRONLY) == 0 && (this.flags & RDWR) == 0;
    }

    public boolean isReadable() {
        return (this.flags & RDWR) != 0 || this.isReadOnly();
    }

    public boolean isBinary() {
        return (this.flags & BINARY) != 0;
    }

    public boolean isCreate() {
        return (this.flags & CREAT) != 0;
    }

    public boolean isWritable() {
        return (this.flags & RDWR) != 0 || (this.flags & WRONLY) != 0;
    }

    public boolean isExclusive() {
        return (this.flags & EXCL) != 0;
    }

    public boolean isAppendable() {
        return (this.flags & APPEND) != 0;
    }

    public boolean isTruncate() {
        return (this.flags & TRUNC) != 0;
    }

    public boolean isSubsetOf(ModeFlags superset) {
        return !(!superset.isReadable() && this.isReadable() || !superset.isWritable() && this.isWritable()) && (superset.isAppendable() || !this.isAppendable());
    }

    public String toString() {
        return "" + this.flags;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getOpenFileFlags() {
        int openFileFlags = 0;
        int readWrite = this.flags & 3;
        openFileFlags = readWrite == RDONLY ? 1 : (readWrite == WRONLY ? 2 : 3);
        if ((this.flags & APPEND) != 0) {
            openFileFlags |= 0x40;
        }
        if ((this.flags & CREAT) != 0) {
            openFileFlags |= 0x80;
        }
        if ((this.flags & BINARY) == BINARY) {
            openFileFlags |= 4;
        }
        return openFileFlags;
    }
}

