/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider;

import java.nio.ByteBuffer;
import jnr.ffi.Address;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.Type;
import jnr.ffi.provider.AbstractArrayMemoryIO;
import jnr.ffi.provider.AbstractBufferMemoryIO;
import jnr.ffi.provider.BoundedMemoryIO;
import jnr.ffi.provider.DelegatingMemoryIO;
import jnr.ffi.provider.ShareMemoryIO;

public abstract class AbstractMemoryIO
extends Pointer {
    private final Runtime runtime;

    protected static final void checkBounds(long size2, long off, long len) {
        if ((off | len | off + len | size2 - (off + len)) < 0L) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected AbstractMemoryIO(Runtime runtime) {
        this.runtime = runtime;
    }

    public final Runtime getRuntime() {
        return this.runtime;
    }

    public int indexOf(long offset2, byte value2) {
        return this.indexOf(offset2, value2, Integer.MAX_VALUE);
    }

    public long getAddress(long offset2) {
        return this.getRuntime().addressSize() == 4 ? (long)this.getInt(offset2) : this.getLongLong(offset2);
    }

    public void putAddress(long offset2, long value2) {
        if (this.getRuntime().addressSize() == 4) {
            this.putInt(offset2, (int)value2);
        } else {
            this.putLongLong(offset2, value2);
        }
    }

    public void checkBounds(long offset2, long size2) {
    }

    public void putAddress(long offset2, Address value2) {
        if (this.getRuntime().addressSize() == 4) {
            this.putInt(offset2, value2.intValue());
        } else {
            this.putLongLong(offset2, value2.longValue());
        }
    }

    public final long getNativeLong(long offset2) {
        return this.getRuntime().longSize() == 4 ? (long)this.getInt(offset2) : this.getLongLong(offset2);
    }

    public void putNativeLong(long offset2, long value2) {
        if (this.getRuntime().longSize() == 4) {
            this.putInt(offset2, (int)value2);
        } else {
            this.putLongLong(offset2, value2);
        }
    }

    public long getLong(long offset2) {
        return this.getRuntime().longSize() == 4 ? (long)this.getInt(offset2) : this.getLong(offset2);
    }

    public void putLong(long offset2, long value2) {
        if (this.getRuntime().longSize() == 4) {
            this.putInt(offset2, (int)value2);
        } else {
            this.putLongLong(offset2, value2);
        }
    }

    public void putInt(Type type2, long offset2, long value2) {
        switch (type2.getNativeType()) {
            case SCHAR: 
            case UCHAR: {
                this.putByte(offset2, (byte)value2);
                break;
            }
            case SSHORT: 
            case USHORT: {
                this.putShort(offset2, (short)value2);
                break;
            }
            case SINT: 
            case UINT: {
                this.putInt(offset2, (int)value2);
                break;
            }
            case SLONG: 
            case ULONG: {
                this.putNativeLong(offset2, value2);
                break;
            }
            case SLONGLONG: 
            case ULONGLONG: {
                this.putLongLong(offset2, value2);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported integer type: " + (Object)((Object)type2.getNativeType()));
            }
        }
    }

    public long getInt(Type type2, long offset2) {
        switch (type2.getNativeType()) {
            case SCHAR: 
            case UCHAR: {
                return this.getByte(offset2);
            }
            case SSHORT: 
            case USHORT: {
                return this.getShort(offset2);
            }
            case SINT: 
            case UINT: {
                return this.getInt(offset2);
            }
            case SLONG: 
            case ULONG: {
                return this.getNativeLong(offset2);
            }
            case SLONGLONG: 
            case ULONGLONG: {
                return this.getLongLong(offset2);
            }
        }
        throw new IllegalArgumentException("unsupported integer type: " + (Object)((Object)type2.getNativeType()));
    }

    public AbstractMemoryIO slice(long offset2) {
        return new ShareMemoryIO(this, offset2);
    }

    public AbstractMemoryIO slice(long offset2, long size2) {
        return new BoundedMemoryIO(this, offset2, size2);
    }

    public void transferTo(long offset2, Pointer other, long otherOffset, long count2) {
        Pointer dst = other instanceof DelegatingMemoryIO ? ((DelegatingMemoryIO)((Object)other)).getDelegatedMemoryIO() : other;
        dst.checkBounds(otherOffset, count2);
        if (dst instanceof AbstractArrayMemoryIO) {
            AbstractArrayMemoryIO aio = (AbstractArrayMemoryIO)dst;
            this.get(offset2, aio.array(), aio.offset() + (int)otherOffset, (int)count2);
        } else if (dst instanceof AbstractBufferMemoryIO && ((AbstractBufferMemoryIO)dst).getByteBuffer().hasArray()) {
            ByteBuffer buf = ((AbstractBufferMemoryIO)dst).getByteBuffer();
            this.get(offset2, buf.array(), buf.arrayOffset() + buf.position() + (int)otherOffset, (int)count2);
        } else {
            for (long i2 = 0L; i2 < count2; ++i2) {
                other.putByte(otherOffset + i2, this.getByte(offset2 + i2));
            }
        }
    }

    public void transferFrom(long offset2, Pointer other, long otherOffset, long count2) {
        Pointer src = other instanceof DelegatingMemoryIO ? ((DelegatingMemoryIO)((Object)other)).getDelegatedMemoryIO() : other;
        src.checkBounds(otherOffset, count2);
        if (src instanceof AbstractArrayMemoryIO) {
            AbstractArrayMemoryIO aio = (AbstractArrayMemoryIO)src;
            this.put(offset2, aio.array(), aio.offset() + (int)otherOffset, (int)count2);
        } else if (src instanceof AbstractBufferMemoryIO && ((AbstractBufferMemoryIO)src).getByteBuffer().hasArray()) {
            ByteBuffer buf = ((AbstractBufferMemoryIO)src).getByteBuffer();
            this.put(offset2, buf.array(), buf.arrayOffset() + buf.position() + (int)otherOffset, (int)count2);
        } else {
            for (long i2 = 0L; i2 < count2; ++i2) {
                this.putByte(offset2 + i2, other.getByte(otherOffset + i2));
            }
        }
    }
}

