/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Sysconf;
import jnr.posix.FileStat;
import jnr.posix.Group;
import jnr.posix.JavaFileStat;
import jnr.posix.JavaLibCHelper;
import jnr.posix.JavaTimes;
import jnr.posix.LibC;
import jnr.posix.POSIX;
import jnr.posix.POSIXHandler;
import jnr.posix.Passwd;
import jnr.posix.Times;
import jnr.posix.util.Java5ProcessMaker;
import jnr.posix.util.Platform;
import jnr.posix.util.ProcessMaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JavaPOSIX
implements POSIX {
    private final POSIXHandler handler;
    private final JavaLibCHelper helper;

    JavaPOSIX(POSIXHandler handler) {
        this.handler = handler;
        this.helper = new JavaLibCHelper(handler);
    }

    @Override
    public ProcessMaker newProcessMaker(String ... command) {
        return new Java5ProcessMaker(this.handler, command);
    }

    @Override
    public ProcessMaker newProcessMaker() {
        return new Java5ProcessMaker(this.handler);
    }

    @Override
    public FileStat allocateStat() {
        return new JavaFileStat(this, this.handler);
    }

    @Override
    public int chmod(String filename2, int mode2) {
        return this.helper.chmod(filename2, mode2);
    }

    @Override
    public int chown(String filename2, int user, int group2) {
        return this.helper.chown(filename2, user, group2);
    }

    @Override
    public int exec(String path2, String ... argv) {
        this.handler.unimplementedError("No exec in Java (yet)");
        return -1;
    }

    @Override
    public int exec(String path2, String[] argv, String[] envp) {
        this.handler.unimplementedError("No exec in Java (yet)");
        return -1;
    }

    @Override
    public int execv(String path2, String[] argv) {
        this.handler.unimplementedError("No execv in Java (yet)");
        return -1;
    }

    @Override
    public int execve(String path2, String[] argv, String[] envp) {
        this.handler.unimplementedError("No execve in Java (yet)");
        return -1;
    }

    @Override
    public FileStat fstat(FileDescriptor descriptor) {
        this.handler.unimplementedError("fstat unimplemented");
        return null;
    }

    @Override
    public FileStat fstat(int descriptor) {
        this.handler.unimplementedError("fstat unimplemented");
        return null;
    }

    @Override
    public int fstat(int fd, FileStat stat2) {
        this.handler.unimplementedError("fstat unimplemented");
        return -1;
    }

    @Override
    public int fstat(FileDescriptor descriptor, FileStat stat2) {
        this.handler.unimplementedError("fstat unimplemented");
        return -1;
    }

    @Override
    public int getegid() {
        return LoginInfo.GID;
    }

    @Override
    public int geteuid() {
        return LoginInfo.UID;
    }

    @Override
    public int getgid() {
        return LoginInfo.GID;
    }

    @Override
    public String getlogin() {
        return this.helper.getlogin();
    }

    @Override
    public int getpgid() {
        return this.unimplementedInt("getpgid");
    }

    @Override
    public int getpgrp() {
        return this.unimplementedInt("getpgrp");
    }

    @Override
    public int getpid() {
        return this.helper.getpid();
    }

    @Override
    public int getppid() {
        return this.unimplementedInt("getppid");
    }

    @Override
    public Passwd getpwent() {
        return this.helper.getpwent();
    }

    @Override
    public Passwd getpwuid(int which) {
        return this.helper.getpwuid(which);
    }

    @Override
    public Group getgrgid(int which) {
        this.handler.unimplementedError("getgrgid unimplemented");
        return null;
    }

    @Override
    public Passwd getpwnam(String which) {
        this.handler.unimplementedError("getpwnam unimplemented");
        return null;
    }

    @Override
    public Group getgrnam(String which) {
        this.handler.unimplementedError("getgrnam unimplemented");
        return null;
    }

    @Override
    public Group getgrent() {
        this.handler.unimplementedError("getgrent unimplemented");
        return null;
    }

    @Override
    public int setpwent() {
        return this.helper.setpwent();
    }

    @Override
    public int endpwent() {
        return this.helper.endpwent();
    }

    @Override
    public int setgrent() {
        return this.unimplementedInt("setgrent");
    }

    @Override
    public int endgrent() {
        return this.unimplementedInt("endgrent");
    }

    @Override
    public String getenv(String envName) {
        return this.helper.getEnv().get(envName);
    }

    @Override
    public int getuid() {
        return LoginInfo.UID;
    }

    @Override
    public int fork() {
        return -1;
    }

    @Override
    public boolean isatty(FileDescriptor fd) {
        return fd == FileDescriptor.in || fd == FileDescriptor.out || fd == FileDescriptor.err;
    }

    @Override
    public int kill(int pid2, int signal2) {
        return this.unimplementedInt("kill");
    }

    @Override
    public int lchmod(String filename2, int mode2) {
        return this.unimplementedInt("lchmod");
    }

    @Override
    public int lchown(String filename2, int user, int group2) {
        return this.unimplementedInt("lchown");
    }

    @Override
    public int link(String oldpath, String newpath) {
        return this.helper.link(oldpath, newpath);
    }

    @Override
    public FileStat lstat(String path2) {
        FileStat stat2 = this.allocateStat();
        if (this.lstat(path2, stat2) < 0) {
            this.handler.error(Errno.ENOENT, path2);
        }
        return stat2;
    }

    @Override
    public int lstat(String path2, FileStat stat2) {
        return this.helper.lstat(path2, stat2);
    }

    @Override
    public int mkdir(String path2, int mode2) {
        return this.helper.mkdir(path2, mode2);
    }

    @Override
    public String readlink(String path2) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(256);
        int result2 = this.helper.readlink(path2, buffer, buffer.capacity());
        if (result2 == -1) {
            return null;
        }
        buffer.position(0);
        buffer.limit(result2);
        return Charset.forName("ASCII").decode(buffer).toString();
    }

    @Override
    public int setenv(String envName, String envValue, int overwrite) {
        Map<String, String> env = this.helper.getEnv();
        if (envName.contains("=")) {
            this.handler.error(Errno.EINVAL, envName);
            return -1;
        }
        if (overwrite == 0 && env.containsKey(envName)) {
            return 0;
        }
        env.put(envName, envValue);
        return 0;
    }

    @Override
    public FileStat stat(String path2) {
        FileStat stat2 = this.allocateStat();
        if (this.helper.stat(path2, stat2) < 0) {
            this.handler.error(Errno.ENOENT, path2);
        }
        return stat2;
    }

    @Override
    public int stat(String path2, FileStat stat2) {
        return this.helper.stat(path2, stat2);
    }

    @Override
    public int symlink(String oldpath, String newpath) {
        return this.helper.symlink(oldpath, newpath);
    }

    @Override
    public int setegid(int egid2) {
        return this.unimplementedInt("setegid");
    }

    @Override
    public int seteuid(int euid2) {
        return this.unimplementedInt("seteuid");
    }

    @Override
    public int setgid(int gid2) {
        return this.unimplementedInt("setgid");
    }

    @Override
    public int getpgid(int pid2) {
        return this.unimplementedInt("getpgid");
    }

    @Override
    public int setpgid(int pid2, int pgid) {
        return this.unimplementedInt("setpgid");
    }

    @Override
    public int setpgrp(int pid2, int pgrp) {
        return this.unimplementedInt("setpgrp");
    }

    @Override
    public int setsid() {
        return this.unimplementedInt("setsid");
    }

    @Override
    public int setuid(int uid2) {
        return this.unimplementedInt("setuid");
    }

    @Override
    public int umask(int mask) {
        return 0;
    }

    @Override
    public int unsetenv(String envName) {
        if (this.helper.getEnv().remove(envName) == null) {
            this.handler.error(Errno.EINVAL, envName);
            return -1;
        }
        return 0;
    }

    @Override
    public int utimes(String path2, long[] atimeval, long[] mtimeval) {
        long mtimeMillis;
        if (mtimeval != null) {
            assert (mtimeval.length == 2);
            mtimeMillis = mtimeval[0] * 1000L + mtimeval[1] / 1000L;
        } else {
            mtimeMillis = System.currentTimeMillis();
        }
        new File(path2).setLastModified(mtimeMillis);
        return 0;
    }

    @Override
    public int wait(int[] status2) {
        return this.unimplementedInt("wait");
    }

    @Override
    public int waitpid(int pid2, int[] status2, int flags) {
        return this.unimplementedInt("waitpid");
    }

    @Override
    public int getpriority(int which, int who) {
        return this.unimplementedInt("getpriority");
    }

    @Override
    public int setpriority(int which, int who, int prio) {
        return this.unimplementedInt("setpriority");
    }

    @Override
    public int posix_spawnp(String path2, List<? extends POSIX.SpawnFileAction> fileActions, List<? extends CharSequence> argv, List<? extends CharSequence> envp) {
        return this.unimplementedInt("posix_spawnp");
    }

    @Override
    public int errno() {
        return 0;
    }

    @Override
    public void errno(int value2) {
    }

    @Override
    public boolean isNative() {
        return false;
    }

    @Override
    public LibC libc() {
        return null;
    }

    private int unimplementedInt(String message2) {
        this.handler.unimplementedError(message2);
        return -1;
    }

    @Override
    public long sysconf(Sysconf name2) {
        switch (name2) {
            case _SC_CLK_TCK: {
                return 1000L;
            }
        }
        this.errno(Errno.EOPNOTSUPP.intValue());
        return -1L;
    }

    @Override
    public Times times() {
        return new JavaTimes();
    }

    private static final class FakePasswd
    implements Passwd {
        private FakePasswd() {
        }

        public String getLoginName() {
            return LoginInfo.USERNAME;
        }

        public String getPassword() {
            return "";
        }

        public long getUID() {
            return LoginInfo.UID;
        }

        public long getGID() {
            return LoginInfo.GID;
        }

        public int getPasswdChangeTime() {
            return 0;
        }

        public String getAccessClass() {
            return "";
        }

        public String getGECOS() {
            return this.getLoginName();
        }

        public String getHome() {
            return "/";
        }

        public String getShell() {
            return "/bin/sh";
        }

        public int getExpire() {
            return -1;
        }
    }

    private static final class IDHelper {
        private static final String ID_CMD = Platform.IS_SOLARIS ? "/usr/xpg4/bin/id" : "/usr/bin/id";
        private static final int NOBODY = Platform.IS_WINDOWS ? 0 : Short.MAX_VALUE;

        private IDHelper() {
        }

        public static int getInt(String option) {
            try {
                Process p2 = Runtime.getRuntime().exec(new String[]{ID_CMD, option});
                BufferedReader r = new BufferedReader(new InputStreamReader(p2.getInputStream()));
                return Integer.parseInt(r.readLine());
            }
            catch (IOException ex) {
                return NOBODY;
            }
            catch (NumberFormatException ex) {
                return NOBODY;
            }
            catch (SecurityException ex) {
                return NOBODY;
            }
        }

        public static String getString(String option) {
            try {
                Process p2 = Runtime.getRuntime().exec(new String[]{ID_CMD, option});
                BufferedReader r = new BufferedReader(new InputStreamReader(p2.getInputStream()));
                return r.readLine();
            }
            catch (IOException ex) {
                return null;
            }
        }
    }

    static final class LoginInfo {
        public static final int UID = IDHelper.getInt("-u");
        public static final int GID = IDHelper.getInt("-g");
        public static final String USERNAME = IDHelper.getString("-un");

        LoginInfo() {
        }
    }
}

