/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import jnr.constants.platform.Sysconf;
import jnr.ffi.Pointer;
import jnr.ffi.mapper.FromNativeContext;
import jnr.posix.BaseNativePOSIX;
import jnr.posix.FileStat;
import jnr.posix.LibCProvider;
import jnr.posix.MacOSFileStat;
import jnr.posix.MacOSPasswd;
import jnr.posix.NativeTimes;
import jnr.posix.POSIXHandler;
import jnr.posix.Times;

final class MacOSPOSIX
extends BaseNativePOSIX {
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public Object fromNative(Object arg2, FromNativeContext ctx) {
            return arg2 != null ? new MacOSPasswd((Pointer)arg2) : null;
        }
    };

    MacOSPOSIX(String libraryName, LibCProvider libcProvider, POSIXHandler handler) {
        super(libraryName, libcProvider, handler);
    }

    public FileStat allocateStat() {
        return new MacOSFileStat(this);
    }

    public int lchmod(String filename2, int mode2) {
        try {
            return this.libc().lchmod(filename2, mode2);
        }
        catch (UnsatisfiedLinkError ex) {
            this.handler.unimplementedError("lchmod");
            return -1;
        }
    }

    public int lchown(String filename2, int user, int group2) {
        try {
            return super.lchown(filename2, user, group2);
        }
        catch (UnsatisfiedLinkError ex) {
            this.handler.unimplementedError("lchown");
            return -1;
        }
    }

    public long sysconf(Sysconf name2) {
        return this.libc().sysconf(name2);
    }

    public Times times() {
        return NativeTimes.times(this);
    }
}

