/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import java.io.FileDescriptor;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Sysconf;
import jnr.ffi.Pointer;
import jnr.ffi.mapper.FromNativeContext;
import jnr.posix.BaseNativePOSIX;
import jnr.posix.FileStat;
import jnr.posix.LibCProvider;
import jnr.posix.NativeTimes;
import jnr.posix.POSIXHandler;
import jnr.posix.SolarisFileStat32;
import jnr.posix.SolarisFileStat64;
import jnr.posix.SolarisPasswd;
import jnr.posix.Times;
import jnr.posix.util.Platform;

final class SolarisPOSIX
extends BaseNativePOSIX {
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public Object fromNative(Object arg2, FromNativeContext ctx) {
            return arg2 != null ? new SolarisPasswd((Pointer)arg2) : null;
        }
    };

    SolarisPOSIX(String libraryName, LibCProvider libc, POSIXHandler handler) {
        super(libraryName, libc, handler);
    }

    public FileStat allocateStat() {
        return Platform.IS_32_BIT ? new SolarisFileStat32(this) : new SolarisFileStat64(this);
    }

    public FileStat fstat(FileDescriptor fileDescriptor) {
        FileStat stat2 = this.allocateStat();
        int fd = this.helper.getfd(fileDescriptor);
        if ((Platform.IS_32_BIT ? this.libc().fstat64(fd, stat2) : this.libc().fstat(fd, stat2)) < 0) {
            this.handler.error(Errno.ENOENT, "" + fd);
        }
        return stat2;
    }

    public int lchmod(String filename2, int mode2) {
        this.handler.unimplementedError("lchmod");
        return -1;
    }

    public int lstat(String path2, FileStat stat2) {
        return Platform.IS_32_BIT ? this.libc().lstat64(path2, stat2) : this.libc().lstat(path2, stat2);
    }

    public int stat(String path2, FileStat stat2) {
        return Platform.IS_32_BIT ? this.libc().stat64(path2, stat2) : this.libc().stat(path2, stat2);
    }

    public long sysconf(Sysconf name2) {
        return this.libc().sysconf(name2);
    }

    public Times times() {
        return NativeTimes.times(this);
    }
}

