/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.IntRecipientInfoGenerator;

class KeyTransIntRecipientInfoGenerator
implements IntRecipientInfoGenerator {
    private TBSCertificateStructure recipientTBSCert;
    private PublicKey recipientPublicKey;
    private ASN1OctetString subjectKeyIdentifier;
    private SubjectPublicKeyInfo info;

    KeyTransIntRecipientInfoGenerator() {
    }

    void setRecipientCert(X509Certificate x509Certificate) {
        this.recipientTBSCert = CMSUtils.getTBSCertificateStructure(x509Certificate);
        this.recipientPublicKey = x509Certificate.getPublicKey();
        this.info = this.recipientTBSCert.getSubjectPublicKeyInfo();
    }

    void setRecipientPublicKey(PublicKey publicKey) {
        this.recipientPublicKey = publicKey;
        try {
            this.info = SubjectPublicKeyInfo.getInstance(ASN1Object.fromByteArray(publicKey.getEncoded()));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("can't extract key algorithm from this key");
        }
    }

    void setSubjectKeyIdentifier(ASN1OctetString aSN1OctetString) {
        this.subjectKeyIdentifier = aSN1OctetString;
    }

    public RecipientInfo generate(SecretKey secretKey, SecureRandom secureRandom, Provider provider) throws GeneralSecurityException {
        RecipientIdentifier recipientIdentifier;
        AlgorithmIdentifier algorithmIdentifier = this.info.getAlgorithmId();
        byte[] byArray = null;
        Cipher cipher2 = CMSEnvelopedHelper.INSTANCE.createAsymmetricCipher(algorithmIdentifier.getObjectId().getId(), provider);
        try {
            cipher2.init(3, (Key)this.recipientPublicKey, secureRandom);
            byArray = cipher2.wrap(secretKey);
        }
        catch (GeneralSecurityException generalSecurityException) {
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (ProviderException providerException) {
            // empty catch block
        }
        if (byArray == null) {
            cipher2.init(1, (Key)this.recipientPublicKey, secureRandom);
            byArray = cipher2.doFinal(secretKey.getEncoded());
        }
        if (this.recipientTBSCert != null) {
            IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(this.recipientTBSCert.getIssuer(), this.recipientTBSCert.getSerialNumber().getValue());
            recipientIdentifier = new RecipientIdentifier(issuerAndSerialNumber);
        } else {
            recipientIdentifier = new RecipientIdentifier(this.subjectKeyIdentifier);
        }
        return new RecipientInfo(new KeyTransRecipientInfo(recipientIdentifier, algorithmIdentifier, new DEROctetString(byArray)));
    }
}

