/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.PasswordRecipientInfo;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.AuthAttributesProvider;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSPBEKey;
import org.bouncycastle.cms.CMSSecureReadable;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.PasswordRecipient;
import org.bouncycastle.cms.PasswordRecipientId;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientOperator;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;

public class PasswordRecipientInformation
extends RecipientInformation {
    static Map KEYSIZES = new HashMap();
    static Map BLOCKSIZES = new HashMap();
    private PasswordRecipientInfo info;

    PasswordRecipientInformation(PasswordRecipientInfo passwordRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(passwordRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = passwordRecipientInfo;
        this.rid = new PasswordRecipientId();
    }

    public String getKeyDerivationAlgOID() {
        if (this.info.getKeyDerivationAlgorithm() != null) {
            return this.info.getKeyDerivationAlgorithm().getObjectId().getId();
        }
        return null;
    }

    public byte[] getKeyDerivationAlgParams() {
        try {
            DEREncodable dEREncodable;
            if (this.info.getKeyDerivationAlgorithm() != null && (dEREncodable = this.info.getKeyDerivationAlgorithm().getParameters()) != null) {
                return dEREncodable.getDERObject().getEncoded();
            }
            return null;
        }
        catch (Exception exception2) {
            throw new RuntimeException("exception getting encryption parameters " + exception2);
        }
    }

    public AlgorithmParameters getKeyDerivationAlgParameters(String string2) throws NoSuchProviderException {
        return this.getKeyDerivationAlgParameters(CMSUtils.getProvider(string2));
    }

    public AlgorithmParameters getKeyDerivationAlgParameters(Provider provider) {
        try {
            DEREncodable dEREncodable;
            if (this.info.getKeyDerivationAlgorithm() != null && (dEREncodable = this.info.getKeyDerivationAlgorithm().getParameters()) != null) {
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(this.info.getKeyDerivationAlgorithm().getObjectId().toString(), provider);
                algorithmParameters.init(dEREncodable.getDERObject().getEncoded());
                return algorithmParameters;
            }
            return null;
        }
        catch (Exception exception2) {
            throw new RuntimeException("exception getting encryption parameters " + exception2);
        }
    }

    public CMSTypedStream getContentStream(Key key2, String string2) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key2, CMSUtils.getProvider(string2));
    }

    public CMSTypedStream getContentStream(Key key2, Provider provider) throws CMSException {
        try {
            CMSEnvelopedHelper cMSEnvelopedHelper = CMSEnvelopedHelper.INSTANCE;
            AlgorithmIdentifier algorithmIdentifier = AlgorithmIdentifier.getInstance(this.info.getKeyEncryptionAlgorithm());
            ASN1Sequence aSN1Sequence = (ASN1Sequence)algorithmIdentifier.getParameters();
            String string2 = DERObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(0)).getId();
            String string3 = cMSEnvelopedHelper.getRFC3211WrapperName(string2);
            Cipher cipher2 = cMSEnvelopedHelper.createSymmetricCipher(string3, provider);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(1)).getOctets());
            cipher2.init(4, (Key)new SecretKeySpec(((CMSPBEKey)key2).getEncoded(string2), string2), ivParameterSpec);
            Key key3 = cipher2.unwrap(this.info.getEncryptedKey().getOctets(), this.getContentAlgorithmName(), 3);
            return this.getContentFromSessionKey(key3, provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("invalid iv.", invalidAlgorithmParameterException);
        }
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        byte[] byArray;
        PasswordRecipient passwordRecipient = (PasswordRecipient)recipient;
        AlgorithmIdentifier algorithmIdentifier = AlgorithmIdentifier.getInstance(this.info.getKeyEncryptionAlgorithm());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)algorithmIdentifier.getParameters();
        DERObjectIdentifier dERObjectIdentifier = DERObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        PBKDF2Params pBKDF2Params = PBKDF2Params.getInstance(this.info.getKeyDerivationAlgorithm().getParameters());
        int n = (Integer)KEYSIZES.get(dERObjectIdentifier);
        if (passwordRecipient.getPasswordConversionScheme() == 0) {
            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator();
            pKCS5S2ParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToBytes(passwordRecipient.getPassword()), pBKDF2Params.getSalt(), pBKDF2Params.getIterationCount().intValue());
            byArray = ((KeyParameter)pKCS5S2ParametersGenerator.generateDerivedParameters(n)).getKey();
        } else {
            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator();
            pKCS5S2ParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(passwordRecipient.getPassword()), pBKDF2Params.getSalt(), pBKDF2Params.getIterationCount().intValue());
            byArray = ((KeyParameter)pKCS5S2ParametersGenerator.generateDerivedParameters(n)).getKey();
        }
        return passwordRecipient.getRecipientOperator(AlgorithmIdentifier.getInstance(algorithmIdentifier.getParameters()), this.messageAlgorithm, byArray, this.info.getEncryptedKey().getOctets());
    }

    static {
        BLOCKSIZES.put(CMSAlgorithm.DES_EDE3_CBC, new Integer(8));
        BLOCKSIZES.put(CMSAlgorithm.AES128_CBC, new Integer(16));
        BLOCKSIZES.put(CMSAlgorithm.AES192_CBC, new Integer(16));
        BLOCKSIZES.put(CMSAlgorithm.AES256_CBC, new Integer(16));
        KEYSIZES.put(CMSAlgorithm.DES_EDE3_CBC, new Integer(192));
        KEYSIZES.put(CMSAlgorithm.AES128_CBC, new Integer(128));
        KEYSIZES.put(CMSAlgorithm.AES192_CBC, new Integer(192));
        KEYSIZES.put(CMSAlgorithm.AES256_CBC, new Integer(256));
    }
}

