/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.examples;

import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.bouncycastle.util.Store;

public class ReadSignedMail {
    private static final String BC = BouncyCastleProvider.PROVIDER_NAME;

    private static void verify(SMIMESigned sMIMESigned) throws Exception {
        Store store = sMIMESigned.getCertificates();
        SignerInformationStore signerInformationStore = sMIMESigned.getSignerInfos();
        Collection collection = signerInformationStore.getSigners();
        for (SignerInformation signerInformation : collection) {
            Collection collection2 = store.getMatches(signerInformation.getSID());
            Iterator iterator = collection2.iterator();
            X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider(BC).getCertificate((X509CertificateHolder)iterator.next());
            if (signerInformation.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(x509Certificate))) {
                System.out.println("signature verified");
                continue;
            }
            System.out.println("signature failed!");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Properties properties = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)properties, null);
        MimeMessage mimeMessage = new MimeMessage(session, (InputStream)new FileInputStream("signed.message"));
        if (mimeMessage.isMimeType("multipart/signed")) {
            SMIMESigned sMIMESigned = new SMIMESigned((MimeMultipart)mimeMessage.getContent());
            MimeBodyPart mimeBodyPart = sMIMESigned.getContent();
            System.out.println("Content:");
            Object object = mimeBodyPart.getContent();
            if (object instanceof String) {
                System.out.println((String)object);
            } else if (object instanceof Multipart) {
                Multipart multipart = (Multipart)object;
                int n = multipart.getCount();
                for (int j = 0; j < n; ++j) {
                    BodyPart bodyPart = multipart.getBodyPart(j);
                    Object object2 = bodyPart.getContent();
                    System.out.println("Part " + j);
                    System.out.println("---------------------------");
                    if (object2 instanceof String) {
                        System.out.println((String)object2);
                        continue;
                    }
                    System.out.println("can't print...");
                }
            }
            System.out.println("Status:");
            ReadSignedMail.verify(sMIMESigned);
        } else if (mimeMessage.isMimeType("application/pkcs7-mime") || mimeMessage.isMimeType("application/x-pkcs7-mime")) {
            SMIMESigned sMIMESigned = new SMIMESigned((Part)mimeMessage);
            MimeBodyPart mimeBodyPart = sMIMESigned.getContent();
            System.out.println("Content:");
            Object object = mimeBodyPart.getContent();
            if (object instanceof String) {
                System.out.println((String)object);
            }
            System.out.println("Status:");
            ReadSignedMail.verify(sMIMESigned);
        } else {
            System.err.println("Not a signed message!");
        }
    }
}

