/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadWritableInstant;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;
import org.joda.time.format.DateTimePrinter;
import org.joda.time.format.FormatUtils;

public class DateTimeFormatter {
    private final DateTimePrinter iPrinter;
    private final DateTimeParser iParser;
    private final Locale iLocale;
    private final boolean iOffsetParsed;
    private final Chronology iChrono;
    private final DateTimeZone iZone;
    private final Integer iPivotYear;
    private final int iDefaultYear;

    public DateTimeFormatter(DateTimePrinter dateTimePrinter, DateTimeParser dateTimeParser) {
        this.iPrinter = dateTimePrinter;
        this.iParser = dateTimeParser;
        this.iLocale = null;
        this.iOffsetParsed = false;
        this.iChrono = null;
        this.iZone = null;
        this.iPivotYear = null;
        this.iDefaultYear = 2000;
    }

    private DateTimeFormatter(DateTimePrinter dateTimePrinter, DateTimeParser dateTimeParser, Locale locale, boolean bl, Chronology chronology, DateTimeZone dateTimeZone, Integer n, int n2) {
        this.iPrinter = dateTimePrinter;
        this.iParser = dateTimeParser;
        this.iLocale = locale;
        this.iOffsetParsed = bl;
        this.iChrono = chronology;
        this.iZone = dateTimeZone;
        this.iPivotYear = n;
        this.iDefaultYear = n2;
    }

    public boolean isPrinter() {
        return this.iPrinter != null;
    }

    public DateTimePrinter getPrinter() {
        return this.iPrinter;
    }

    public boolean isParser() {
        return this.iParser != null;
    }

    public DateTimeParser getParser() {
        return this.iParser;
    }

    public DateTimeFormatter withLocale(Locale locale) {
        if (locale == this.getLocale() || locale != null && locale.equals(this.getLocale())) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, locale, this.iOffsetParsed, this.iChrono, this.iZone, this.iPivotYear, this.iDefaultYear);
    }

    public Locale getLocale() {
        return this.iLocale;
    }

    public DateTimeFormatter withOffsetParsed() {
        if (this.iOffsetParsed) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, true, this.iChrono, null, this.iPivotYear, this.iDefaultYear);
    }

    public boolean isOffsetParsed() {
        return this.iOffsetParsed;
    }

    public DateTimeFormatter withChronology(Chronology chronology) {
        if (this.iChrono == chronology) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, this.iOffsetParsed, chronology, this.iZone, this.iPivotYear, this.iDefaultYear);
    }

    public Chronology getChronology() {
        return this.iChrono;
    }

    @Deprecated
    public Chronology getChronolgy() {
        return this.iChrono;
    }

    public DateTimeFormatter withZoneUTC() {
        return this.withZone(DateTimeZone.UTC);
    }

    public DateTimeFormatter withZone(DateTimeZone dateTimeZone) {
        if (this.iZone == dateTimeZone) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, false, this.iChrono, dateTimeZone, this.iPivotYear, this.iDefaultYear);
    }

    public DateTimeZone getZone() {
        return this.iZone;
    }

    public DateTimeFormatter withPivotYear(Integer n) {
        if (this.iPivotYear == n || this.iPivotYear != null && this.iPivotYear.equals(n)) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, this.iOffsetParsed, this.iChrono, this.iZone, n, this.iDefaultYear);
    }

    public DateTimeFormatter withPivotYear(int n) {
        return this.withPivotYear((Integer)n);
    }

    public Integer getPivotYear() {
        return this.iPivotYear;
    }

    public DateTimeFormatter withDefaultYear(int n) {
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, this.iOffsetParsed, this.iChrono, this.iZone, this.iPivotYear, n);
    }

    public int getDefaultYear() {
        return this.iDefaultYear;
    }

    public void printTo(StringBuffer stringBuffer, ReadableInstant readableInstant) {
        long l = DateTimeUtils.getInstantMillis(readableInstant);
        Chronology chronology = DateTimeUtils.getInstantChronology(readableInstant);
        this.printTo(stringBuffer, l, chronology);
    }

    public void printTo(Writer writer, ReadableInstant readableInstant) throws IOException {
        long l = DateTimeUtils.getInstantMillis(readableInstant);
        Chronology chronology = DateTimeUtils.getInstantChronology(readableInstant);
        this.printTo(writer, l, chronology);
    }

    public void printTo(Appendable appendable, ReadableInstant readableInstant) throws IOException {
        appendable.append(this.print(readableInstant));
    }

    public void printTo(StringBuffer stringBuffer, long l) {
        this.printTo(stringBuffer, l, null);
    }

    public void printTo(Writer writer, long l) throws IOException {
        this.printTo(writer, l, null);
    }

    public void printTo(Appendable appendable, long l) throws IOException {
        appendable.append(this.print(l));
    }

    public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial) {
        DateTimePrinter dateTimePrinter = this.requirePrinter();
        if (readablePartial == null) {
            throw new IllegalArgumentException("The partial must not be null");
        }
        dateTimePrinter.printTo(stringBuffer, readablePartial, this.iLocale);
    }

    public void printTo(Writer writer, ReadablePartial readablePartial) throws IOException {
        DateTimePrinter dateTimePrinter = this.requirePrinter();
        if (readablePartial == null) {
            throw new IllegalArgumentException("The partial must not be null");
        }
        dateTimePrinter.printTo(writer, readablePartial, this.iLocale);
    }

    public void printTo(Appendable appendable, ReadablePartial readablePartial) throws IOException {
        appendable.append(this.print(readablePartial));
    }

    public String print(ReadableInstant readableInstant) {
        StringBuffer stringBuffer = new StringBuffer(this.requirePrinter().estimatePrintedLength());
        this.printTo(stringBuffer, readableInstant);
        return stringBuffer.toString();
    }

    public String print(long l) {
        StringBuffer stringBuffer = new StringBuffer(this.requirePrinter().estimatePrintedLength());
        this.printTo(stringBuffer, l);
        return stringBuffer.toString();
    }

    public String print(ReadablePartial readablePartial) {
        StringBuffer stringBuffer = new StringBuffer(this.requirePrinter().estimatePrintedLength());
        this.printTo(stringBuffer, readablePartial);
        return stringBuffer.toString();
    }

    private void printTo(StringBuffer stringBuffer, long l, Chronology chronology) {
        DateTimePrinter dateTimePrinter = this.requirePrinter();
        DateTimeZone dateTimeZone = (chronology = this.selectChronology(chronology)).getZone();
        int n = dateTimeZone.getOffset(l);
        long l2 = l + (long)n;
        if ((l ^ l2) < 0L && (l ^ (long)n) >= 0L) {
            dateTimeZone = DateTimeZone.UTC;
            n = 0;
            l2 = l;
        }
        dateTimePrinter.printTo(stringBuffer, l2, chronology.withUTC(), n, dateTimeZone, this.iLocale);
    }

    private void printTo(Writer writer, long l, Chronology chronology) throws IOException {
        DateTimePrinter dateTimePrinter = this.requirePrinter();
        DateTimeZone dateTimeZone = (chronology = this.selectChronology(chronology)).getZone();
        int n = dateTimeZone.getOffset(l);
        long l2 = l + (long)n;
        if ((l ^ l2) < 0L && (l ^ (long)n) >= 0L) {
            dateTimeZone = DateTimeZone.UTC;
            n = 0;
            l2 = l;
        }
        dateTimePrinter.printTo(writer, l2, chronology.withUTC(), n, dateTimeZone, this.iLocale);
    }

    private DateTimePrinter requirePrinter() {
        DateTimePrinter dateTimePrinter = this.iPrinter;
        if (dateTimePrinter == null) {
            throw new UnsupportedOperationException("Printing not supported");
        }
        return dateTimePrinter;
    }

    public int parseInto(ReadWritableInstant readWritableInstant, String string2, int n) {
        DateTimeParser dateTimeParser = this.requireParser();
        if (readWritableInstant == null) {
            throw new IllegalArgumentException("Instant must not be null");
        }
        long l = readWritableInstant.getMillis();
        Chronology chronology = readWritableInstant.getChronology();
        long l2 = l + (long)chronology.getZone().getOffset(l);
        chronology = this.selectChronology(chronology);
        DateTimeParserBucket dateTimeParserBucket = new DateTimeParserBucket(l2, chronology, this.iLocale, this.iPivotYear, this.iDefaultYear);
        int n2 = dateTimeParser.parseInto(dateTimeParserBucket, string2, n);
        readWritableInstant.setMillis(dateTimeParserBucket.computeMillis(false, string2));
        if (this.iOffsetParsed && dateTimeParserBucket.getOffsetInteger() != null) {
            int n3 = dateTimeParserBucket.getOffsetInteger();
            DateTimeZone dateTimeZone = DateTimeZone.forOffsetMillis(n3);
            chronology = chronology.withZone(dateTimeZone);
        } else if (dateTimeParserBucket.getZone() != null) {
            chronology = chronology.withZone(dateTimeParserBucket.getZone());
        }
        readWritableInstant.setChronology(chronology);
        if (this.iZone != null) {
            readWritableInstant.setZone(this.iZone);
        }
        return n2;
    }

    public long parseMillis(String string2) {
        Chronology chronology;
        DateTimeParserBucket dateTimeParserBucket;
        DateTimeParser dateTimeParser = this.requireParser();
        int n = dateTimeParser.parseInto(dateTimeParserBucket = new DateTimeParserBucket(0L, chronology = this.selectChronology(this.iChrono), this.iLocale, this.iPivotYear, this.iDefaultYear), string2, 0);
        if (n >= 0) {
            if (n >= string2.length()) {
                return dateTimeParserBucket.computeMillis(true, string2);
            }
        } else {
            n ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(string2, n));
    }

    public LocalDate parseLocalDate(String string2) {
        return this.parseLocalDateTime(string2).toLocalDate();
    }

    public LocalTime parseLocalTime(String string2) {
        return this.parseLocalDateTime(string2).toLocalTime();
    }

    public LocalDateTime parseLocalDateTime(String string2) {
        Chronology chronology;
        DateTimeParserBucket dateTimeParserBucket;
        DateTimeParser dateTimeParser = this.requireParser();
        int n = dateTimeParser.parseInto(dateTimeParserBucket = new DateTimeParserBucket(0L, chronology = this.selectChronology(null).withUTC(), this.iLocale, this.iPivotYear, this.iDefaultYear), string2, 0);
        if (n >= 0) {
            if (n >= string2.length()) {
                long l = dateTimeParserBucket.computeMillis(true, string2);
                if (dateTimeParserBucket.getOffsetInteger() != null) {
                    int n2 = dateTimeParserBucket.getOffsetInteger();
                    DateTimeZone dateTimeZone = DateTimeZone.forOffsetMillis(n2);
                    chronology = chronology.withZone(dateTimeZone);
                } else if (dateTimeParserBucket.getZone() != null) {
                    chronology = chronology.withZone(dateTimeParserBucket.getZone());
                }
                return new LocalDateTime(l, chronology);
            }
        } else {
            n ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(string2, n));
    }

    public DateTime parseDateTime(String string2) {
        Chronology chronology;
        DateTimeParserBucket dateTimeParserBucket;
        DateTimeParser dateTimeParser = this.requireParser();
        int n = dateTimeParser.parseInto(dateTimeParserBucket = new DateTimeParserBucket(0L, chronology = this.selectChronology(null), this.iLocale, this.iPivotYear, this.iDefaultYear), string2, 0);
        if (n >= 0) {
            if (n >= string2.length()) {
                long l = dateTimeParserBucket.computeMillis(true, string2);
                if (this.iOffsetParsed && dateTimeParserBucket.getOffsetInteger() != null) {
                    int n2 = dateTimeParserBucket.getOffsetInteger();
                    DateTimeZone dateTimeZone = DateTimeZone.forOffsetMillis(n2);
                    chronology = chronology.withZone(dateTimeZone);
                } else if (dateTimeParserBucket.getZone() != null) {
                    chronology = chronology.withZone(dateTimeParserBucket.getZone());
                }
                DateTime dateTime = new DateTime(l, chronology);
                if (this.iZone != null) {
                    dateTime = dateTime.withZone(this.iZone);
                }
                return dateTime;
            }
        } else {
            n ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(string2, n));
    }

    public MutableDateTime parseMutableDateTime(String string2) {
        Chronology chronology;
        DateTimeParserBucket dateTimeParserBucket;
        DateTimeParser dateTimeParser = this.requireParser();
        int n = dateTimeParser.parseInto(dateTimeParserBucket = new DateTimeParserBucket(0L, chronology = this.selectChronology(null), this.iLocale, this.iPivotYear, this.iDefaultYear), string2, 0);
        if (n >= 0) {
            if (n >= string2.length()) {
                long l = dateTimeParserBucket.computeMillis(true, string2);
                if (this.iOffsetParsed && dateTimeParserBucket.getOffsetInteger() != null) {
                    int n2 = dateTimeParserBucket.getOffsetInteger();
                    DateTimeZone dateTimeZone = DateTimeZone.forOffsetMillis(n2);
                    chronology = chronology.withZone(dateTimeZone);
                } else if (dateTimeParserBucket.getZone() != null) {
                    chronology = chronology.withZone(dateTimeParserBucket.getZone());
                }
                MutableDateTime mutableDateTime = new MutableDateTime(l, chronology);
                if (this.iZone != null) {
                    mutableDateTime.setZone(this.iZone);
                }
                return mutableDateTime;
            }
        } else {
            n ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(string2, n));
    }

    private DateTimeParser requireParser() {
        DateTimeParser dateTimeParser = this.iParser;
        if (dateTimeParser == null) {
            throw new UnsupportedOperationException("Parsing not supported");
        }
        return dateTimeParser;
    }

    private Chronology selectChronology(Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology);
        if (this.iChrono != null) {
            chronology = this.iChrono;
        }
        if (this.iZone != null) {
            chronology = chronology.withZone(this.iZone);
        }
        return chronology;
    }
}

