/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.Encoding;
import org.joni.Analyser;
import org.joni.Regex;
import org.joni.ast.AnchorNode;
import org.joni.ast.BackRefNode;
import org.joni.ast.CClassNode;
import org.joni.ast.CTypeNode;
import org.joni.ast.CallNode;
import org.joni.ast.ConsAltNode;
import org.joni.ast.EncloseNode;
import org.joni.ast.Node;
import org.joni.ast.QuantifierNode;
import org.joni.ast.StringNode;
import org.joni.exception.ErrorMessages;
import org.joni.exception.InternalException;
import org.joni.exception.SyntaxException;

abstract class Compiler
implements ErrorMessages {
    protected final Analyser analyser;
    protected final Encoding enc;
    protected final Regex regex;

    protected Compiler(Analyser analyser) {
        this.analyser = analyser;
        this.regex = analyser.regex;
        this.enc = this.regex.enc;
    }

    final void compile() {
        this.prepare();
        this.compileTree(this.analyser.root);
        this.finish();
    }

    protected abstract void prepare();

    protected abstract void finish();

    protected abstract void compileAltNode(ConsAltNode var1);

    private void compileStringRawNode(StringNode sn2) {
        if (sn2.length() <= 0) {
            return;
        }
        this.addCompileString(sn2.bytes, sn2.p, 1, sn2.length(), false);
    }

    private void compileStringNode(StringNode node) {
        int prev;
        StringNode sn2 = node;
        if (sn2.length() <= 0) {
            return;
        }
        boolean ambig = sn2.isAmbig();
        int p2 = prev = sn2.p;
        int end2 = sn2.end;
        byte[] bytes2 = sn2.bytes;
        int prevLen = this.enc.length(bytes2, p2, end2);
        p2 += prevLen;
        int slen = 1;
        while (p2 < end2) {
            int len = this.enc.length(bytes2, p2, end2);
            if (len == prevLen) {
                ++slen;
            } else {
                this.addCompileString(bytes2, prev, prevLen, slen, ambig);
                prev = p2;
                slen = 1;
                prevLen = len;
            }
            p2 += len;
        }
        this.addCompileString(bytes2, prev, prevLen, slen, ambig);
    }

    protected abstract void addCompileString(byte[] var1, int var2, int var3, int var4, boolean var5);

    protected abstract void compileCClassNode(CClassNode var1);

    protected abstract void compileCTypeNode(CTypeNode var1);

    protected abstract void compileAnyCharNode();

    protected abstract void compileCallNode(CallNode var1);

    protected abstract void compileBackrefNode(BackRefNode var1);

    protected abstract void compileCECQuantifierNode(QuantifierNode var1);

    protected abstract void compileNonCECQuantifierNode(QuantifierNode var1);

    protected abstract void compileOptionNode(EncloseNode var1);

    protected abstract void compileEncloseNode(EncloseNode var1);

    protected abstract void compileAnchorNode(AnchorNode var1);

    protected final void compileTree(Node node) {
        switch (node.getType()) {
            case 8: {
                ConsAltNode lin = (ConsAltNode)node;
                do {
                    this.compileTree(lin.car);
                } while ((lin = lin.cdr) != null);
                break;
            }
            case 9: {
                this.compileAltNode((ConsAltNode)node);
                break;
            }
            case 0: {
                StringNode sn2 = (StringNode)node;
                if (sn2.isRaw()) {
                    this.compileStringRawNode(sn2);
                    break;
                }
                this.compileStringNode(sn2);
                break;
            }
            case 1: {
                this.compileCClassNode((CClassNode)node);
                break;
            }
            case 2: {
                this.compileCTypeNode((CTypeNode)node);
                break;
            }
            case 3: {
                this.compileAnyCharNode();
                break;
            }
            case 4: {
                this.compileBackrefNode((BackRefNode)node);
                break;
            }
            case 10: {
                this.compileCallNode((CallNode)node);
                break;
            }
            case 5: {
                this.compileNonCECQuantifierNode((QuantifierNode)node);
                break;
            }
            case 6: {
                EncloseNode enode = (EncloseNode)node;
                if (enode.isOption()) {
                    this.compileOptionNode(enode);
                    break;
                }
                this.compileEncloseNode(enode);
                break;
            }
            case 7: {
                this.compileAnchorNode((AnchorNode)node);
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
            }
        }
    }

    protected final void compileTreeNTimes(Node node, int n) {
        for (int i2 = 0; i2 < n; ++i2) {
            this.compileTree(node);
        }
    }

    protected void newSyntaxException(String message2) {
        throw new SyntaxException(message2);
    }

    protected void newInternalException(String message2) {
        throw new InternalException(message2);
    }
}

