/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyModule(name={"GC"})
public class RubyGC {
    private static volatile boolean gcDisabled = false;
    private static volatile boolean stress = false;

    public static RubyModule createGCModule(Ruby runtime) {
        RubyModule result2 = runtime.defineModule("GC");
        runtime.setGC(result2);
        result2.defineAnnotatedMethods(RubyGC.class);
        return result2;
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject start(ThreadContext context, IRubyObject recv2) {
        return context.runtime.getNil();
    }

    @JRubyMethod
    public static IRubyObject garbage_collect(ThreadContext context, IRubyObject recv2) {
        return context.runtime.getNil();
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject enable(ThreadContext context, IRubyObject recv2) {
        Ruby runtime = context.runtime;
        RubyGC.emptyImplementationWarning(runtime, "GC.enable");
        boolean old = gcDisabled;
        gcDisabled = false;
        return runtime.newBoolean(old);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject disable(ThreadContext context, IRubyObject recv2) {
        Ruby runtime = context.runtime;
        RubyGC.emptyImplementationWarning(runtime, "GC.disable");
        boolean old = gcDisabled;
        gcDisabled = true;
        return runtime.newBoolean(old);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject stress(ThreadContext context, IRubyObject recv2) {
        return context.runtime.newBoolean(stress);
    }

    @JRubyMethod(name={"stress="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject stress_set(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        RubyGC.emptyImplementationWarning(runtime, "GC.stress=");
        stress = arg2.isTrue();
        return runtime.newBoolean(stress);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject count(ThreadContext context, IRubyObject recv2) {
        try {
            int count2 = 0;
            for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
                count2 = (int)((long)count2 + bean.getCollectionCount());
            }
            return context.runtime.newFixnum(count2);
        }
        catch (Throwable t) {
            return RubyFixnum.minus_one(context.runtime);
        }
    }

    private static void emptyImplementationWarning(Ruby runtime, String name2) {
        runtime.getWarnings().warn(IRubyWarnings.ID.EMPTY_IMPLEMENTATION, name2 + " does nothing on JRuby");
    }
}

