/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"SystemExit"}, parent="Exception")
public class RubySystemExit
extends RubyException {
    IRubyObject status;
    private static ObjectAllocator SYSTEMEXIT_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubySystemExit(runtime, klass);
        }
    };

    public static RubyClass createSystemExitClass(Ruby runtime, RubyClass exceptionClass) {
        RubyClass systemExitClass = runtime.defineClass("SystemExit", exceptionClass, SYSTEMEXIT_ALLOCATOR);
        systemExitClass.defineAnnotatedMethods(RubySystemExit.class);
        return systemExitClass;
    }

    public static RubySystemExit newInstance(Ruby runtime, int status2) {
        RubyClass exc = runtime.getSystemExit();
        IRubyObject[] exArgs = new IRubyObject[]{runtime.newFixnum(status2), runtime.newString("exit")};
        return (RubySystemExit)exc.newInstance(runtime.getCurrentContext(), exArgs, Block.NULL_BLOCK);
    }

    protected RubySystemExit(Ruby runtime, RubyClass exceptionClass) {
        super(runtime, exceptionClass);
        this.status = runtime.getNil();
    }

    @JRubyMethod(optional=2, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        this.status = RubyFixnum.zero(this.getRuntime());
        if (args2.length > 0 && args2[0] instanceof RubyFixnum) {
            this.status = args2[0];
            IRubyObject[] tmpArgs = new IRubyObject[args2.length - 1];
            System.arraycopy(args2, 1, tmpArgs, 0, tmpArgs.length);
            args2 = tmpArgs;
        }
        super.initialize(args2, block);
        return this;
    }

    @JRubyMethod
    public IRubyObject status() {
        return this.status;
    }

    @JRubyMethod(name={"success?"})
    public IRubyObject success_p() {
        if (this.status.isNil()) {
            return this.getRuntime().getTrue();
        }
        if (this.status.equals(RubyFixnum.zero(this.getRuntime()))) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }
}

