/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import org.bouncycastle.asn1.pkcs.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.X509Name;
import org.jruby.ext.openssl.impl.ASN1Registry;
import org.jruby.ext.openssl.impl.EVP;
import org.jruby.ext.openssl.impl.PKCS7Exception;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;

public class SignerInfoWithPkey
extends ASN1Encodable {
    private DERInteger version;
    private IssuerAndSerialNumber issuerAndSerialNumber;
    private AlgorithmIdentifier digAlgorithm;
    private ASN1Set authenticatedAttributes;
    private AlgorithmIdentifier digEncryptionAlgorithm;
    private ASN1OctetString encryptedDigest;
    private ASN1Set unauthenticatedAttributes;
    private PrivateKey pkey;

    public static SignerInfoWithPkey getInstance(Object o) {
        if (o instanceof SignerInfo) {
            return (SignerInfoWithPkey)o;
        }
        if (o instanceof ASN1Sequence) {
            return new SignerInfoWithPkey((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("unknown object in factory: " + o.getClass().getName());
    }

    public SignerInfoWithPkey dup() {
        SignerInfoWithPkey copy = new SignerInfoWithPkey(this.version, this.issuerAndSerialNumber, this.digAlgorithm, this.authenticatedAttributes, this.digEncryptionAlgorithm, this.encryptedDigest, this.unauthenticatedAttributes);
        copy.pkey = this.pkey;
        return copy;
    }

    SignerInfoWithPkey() {
    }

    public SignerInfoWithPkey(DERInteger version2, IssuerAndSerialNumber issuerAndSerialNumber, AlgorithmIdentifier digAlgorithm, ASN1Set authenticatedAttributes, AlgorithmIdentifier digEncryptionAlgorithm, ASN1OctetString encryptedDigest, ASN1Set unauthenticatedAttributes) {
        this.version = version2;
        this.issuerAndSerialNumber = issuerAndSerialNumber;
        this.digAlgorithm = digAlgorithm;
        this.authenticatedAttributes = authenticatedAttributes;
        this.digEncryptionAlgorithm = digEncryptionAlgorithm;
        this.encryptedDigest = encryptedDigest;
        this.unauthenticatedAttributes = unauthenticatedAttributes;
    }

    public SignerInfoWithPkey(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.version = (DERInteger)e.nextElement();
        this.issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(e.nextElement());
        this.digAlgorithm = AlgorithmIdentifier.getInstance(e.nextElement());
        Object obj = e.nextElement();
        if (obj instanceof ASN1TaggedObject) {
            this.authenticatedAttributes = ASN1Set.getInstance((ASN1TaggedObject)obj, false);
            this.digEncryptionAlgorithm = AlgorithmIdentifier.getInstance(e.nextElement());
        } else {
            this.authenticatedAttributes = null;
            this.digEncryptionAlgorithm = AlgorithmIdentifier.getInstance(obj);
        }
        this.encryptedDigest = ASN1OctetString.getInstance(e.nextElement());
        this.unauthenticatedAttributes = e.hasMoreElements() ? ASN1Set.getInstance((ASN1TaggedObject)e.nextElement(), false) : null;
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.issuerAndSerialNumber;
    }

    public ASN1Set getAuthenticatedAttributes() {
        return this.authenticatedAttributes;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digAlgorithm;
    }

    public ASN1OctetString getEncryptedDigest() {
        return this.encryptedDigest;
    }

    public AlgorithmIdentifier getDigestEncryptionAlgorithm() {
        return this.digEncryptionAlgorithm;
    }

    public ASN1Set getUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes;
    }

    public void set(X509AuxCertificate x509, PrivateKey pkey, MessageDigest dgst) throws PKCS7Exception {
        boolean dsa = pkey instanceof DSAPrivateKey || pkey instanceof ECPrivateKey;
        this.version = new DERInteger(1);
        try {
            X509Name issuer2 = X509Name.getInstance(new ASN1InputStream(new ByteArrayInputStream(x509.getIssuerX500Principal().getEncoded())).readObject());
            BigInteger serial2 = x509.getSerialNumber();
            this.issuerAndSerialNumber = new IssuerAndSerialNumber(issuer2, serial2);
        }
        catch (IOException e) {
            throw new PKCS7Exception(-1, -1, e);
        }
        this.pkey = pkey;
        this.digAlgorithm = dsa ? new AlgorithmIdentifier(ASN1Registry.nid2obj(64)) : new AlgorithmIdentifier(ASN1Registry.nid2obj(EVP.type(dgst)));
        if (pkey instanceof RSAPrivateKey) {
            this.digEncryptionAlgorithm = new AlgorithmIdentifier(ASN1Registry.nid2obj(6));
        } else if (pkey instanceof DSAPrivateKey) {
            this.digEncryptionAlgorithm = new AlgorithmIdentifier(ASN1Registry.nid2obj(116));
        } else if (pkey instanceof ECPrivateKey) {
            this.digEncryptionAlgorithm = new AlgorithmIdentifier(ASN1Registry.nid2obj(416));
        }
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.version);
        v.add(this.issuerAndSerialNumber);
        v.add(this.digAlgorithm);
        if (this.authenticatedAttributes != null) {
            v.add(new DERTaggedObject(false, 0, this.authenticatedAttributes));
        }
        v.add(this.digEncryptionAlgorithm);
        v.add(this.encryptedDigest);
        if (this.unauthenticatedAttributes != null) {
            v.add(new DERTaggedObject(false, 1, this.unauthenticatedAttributes));
        }
        return new DERSequence(v);
    }

    public final PrivateKey getPkey() {
        return this.pkey;
    }

    public final void setPkey(PrivateKey newPkey) {
        this.pkey = newPkey;
    }

    public void setAuthenticatedAttributes(ASN1Set authAttr) {
        this.authenticatedAttributes = authAttr;
    }

    public void setUnauthenticatedAttributes(ASN1Set unauthAttr) {
        this.unauthenticatedAttributes = unauthAttr;
    }

    public void setEncryptedDigest(ASN1OctetString encryptedDigest) {
        this.encryptedDigest = encryptedDigest;
    }

    public DEREncodable getSignedAttribute(int nid) {
        return SignerInfoWithPkey.getAttribute(this.authenticatedAttributes, nid);
    }

    public DEREncodable getAttribute(int nid) {
        return SignerInfoWithPkey.getAttribute(this.unauthenticatedAttributes, nid);
    }

    public static DEREncodable getAttribute(ASN1Set sk, int nid) {
        Attribute xa = null;
        DERObjectIdentifier o = ASN1Registry.nid2obj(nid);
        if (null == o || null == sk) {
            return null;
        }
        Enumeration e = sk.getObjects();
        while (e.hasMoreElements()) {
            Object val = e.nextElement();
            xa = val instanceof Attribute ? (Attribute)val : Attribute.getInstance(val);
            if (!o.equals(xa.getAttrType())) continue;
            if (xa.getAttrValues().size() > 0) {
                return xa.getAttrValues().getObjectAt(0);
            }
            return null;
        }
        return null;
    }

    public void addSignedAttribute(int atrType, DEREncodable value2) {
        this.authenticatedAttributes = this.addAttribute(this.authenticatedAttributes, atrType, value2);
    }

    public void addAttribute(int atrType, DEREncodable value2) {
        this.unauthenticatedAttributes = this.addAttribute(this.unauthenticatedAttributes, atrType, value2);
    }

    private ASN1Set addAttribute(ASN1Set base, int atrType, DEREncodable value2) {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        if (base == null) {
            base = new DERSet();
        }
        Attribute attr2 = null;
        Enumeration e = base.getObjects();
        while (e.hasMoreElements()) {
            Object val = e.nextElement();
            attr2 = val instanceof Attribute ? (Attribute)val : Attribute.getInstance(val);
            if (ASN1Registry.obj2nid(attr2.getAttrType()) == atrType) continue;
            vector.add(attr2);
        }
        attr2 = new Attribute(ASN1Registry.nid2obj(atrType), new DERSet(value2));
        vector.add(attr2);
        return new DERSet(vector);
    }
}

