/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.Framing;
import org.jruby.internal.runtime.methods.Scoping;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CallConfiguration {
    FrameFullScopeFull(Framing.Full, Scoping.Full){

        void pre(ThreadContext context, IRubyObject self, RubyModule implementer, String name2, Block block, StaticScope scope) {
            context.preMethodFrameAndScope(implementer, name2, self, block, scope);
        }

        void post(ThreadContext context) {
            context.postMethodFrameAndScope();
        }
    }
    ,
    FrameFullScopeDummy(Framing.Full, Scoping.Dummy){

        void pre(ThreadContext context, IRubyObject self, RubyModule implementer, String name2, Block block, StaticScope scope) {
            context.preMethodFrameAndDummyScope(implementer, name2, self, block, scope);
        }

        void post(ThreadContext context) {
            context.postMethodFrameAndScope();
        }
    }
    ,
    FrameFullScopeNone(Framing.Full, Scoping.None){

        void pre(ThreadContext context, IRubyObject self, RubyModule implementer, String name2, Block block, StaticScope scope) {
            context.preMethodFrameOnly(implementer, name2, self, block);
        }

        void post(ThreadContext context) {
            context.postMethodFrameOnly();
        }
    }
    ,
    FrameBacktraceScopeFull(Framing.Backtrace, Scoping.Full){

        void pre(ThreadContext context, IRubyObject self, RubyModule implementer, String name2, Block block, StaticScope scope) {
            context.preMethodBacktraceAndScope(name2, implementer, scope);
        }

        void post(ThreadContext context) {
            context.postMethodBacktraceAndScope();
        }
    }
    ,
    FrameBacktraceScopeDummy(Framing.Backtrace, Scoping.Dummy){

        void pre(ThreadContext context, IRubyObject self, RubyModule implementer, String name2, Block block, StaticScope scope) {
            context.preMethodBacktraceDummyScope(implementer, name2, scope);
        }

        void post(ThreadContext context) {
            context.postMethodBacktraceDummyScope();
        }
    }
    ,
    FrameBacktraceScopeNone(Framing.Backtrace, Scoping.None){

        void pre(ThreadContext context, IRubyObject self, RubyModule implementer, String name2, Block block, StaticScope scope) {
            context.preMethodBacktraceOnly(name2);
        }

        void post(ThreadContext context) {
            context.postMethodBacktraceOnly();
        }
    }
    ,
    FrameNoneScopeFull(Framing.None, Scoping.Full){

        void pre(ThreadContext context, IRubyObject self, RubyModule implementer, String name2, Block block, StaticScope scope) {
            context.preMethodScopeOnly(implementer, scope);
        }

        void post(ThreadContext context) {
            context.postMethodScopeOnly();
        }
    }
    ,
    FrameNoneScopeDummy(Framing.None, Scoping.Dummy){

        void pre(ThreadContext context, IRubyObject self, RubyModule implementer, String name2, Block block, StaticScope scope) {
            context.preMethodNoFrameAndDummyScope(implementer, scope);
        }

        void post(ThreadContext context) {
            context.postMethodScopeOnly();
        }
    }
    ,
    FrameNoneScopeNone(Framing.None, Scoping.None){

        void pre(ThreadContext context, IRubyObject self, RubyModule implementer, String name2, Block block, StaticScope scope) {
        }

        void post(ThreadContext context) {
        }
    };

    @Deprecated
    public static final CallConfiguration FRAME_AND_SCOPE;
    @Deprecated
    public static final CallConfiguration FRAME_AND_DUMMY_SCOPE;
    @Deprecated
    public static final CallConfiguration FRAME_ONLY;
    @Deprecated
    public static final CallConfiguration BACKTRACE_AND_SCOPE;
    @Deprecated
    public static final CallConfiguration BACKTRACE_DUMMY_SCOPE;
    @Deprecated
    public static final CallConfiguration BACKTRACE_ONLY;
    @Deprecated
    public static final CallConfiguration SCOPE_ONLY;
    @Deprecated
    public static final CallConfiguration NO_FRAME_DUMMY_SCOPE;
    @Deprecated
    public static final CallConfiguration NO_FRAME_NO_SCOPE;
    private final Framing framing;
    private final Scoping scoping;

    public static CallConfiguration getCallConfigByAnno(JRubyMethod anno) {
        return CallConfiguration.getCallConfig(anno.frame(), anno.scope());
    }

    @Deprecated
    public static CallConfiguration getCallConfig(boolean frame, boolean scope, boolean backtrace2) {
        return CallConfiguration.getCallConfig(frame, scope);
    }

    public static CallConfiguration getCallConfig(boolean frame, boolean scope) {
        if (frame) {
            if (scope) {
                return FrameFullScopeFull;
            }
            return FrameFullScopeNone;
        }
        if (scope) {
            return FrameNoneScopeFull;
        }
        return FrameNoneScopeNone;
    }

    private CallConfiguration(Framing framing, Scoping scoping) {
        this.framing = framing;
        this.scoping = scoping;
    }

    public final Framing framing() {
        return this.framing;
    }

    public final Scoping scoping() {
        return this.scoping;
    }

    abstract void pre(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5, StaticScope var6);

    abstract void post(ThreadContext var1);

    boolean isNoop() {
        return this.framing == Framing.None && this.scoping == Scoping.None;
    }

    static {
        FRAME_AND_SCOPE = FrameFullScopeFull;
        FRAME_AND_DUMMY_SCOPE = FrameFullScopeDummy;
        FRAME_ONLY = FrameFullScopeNone;
        BACKTRACE_AND_SCOPE = FrameBacktraceScopeFull;
        BACKTRACE_DUMMY_SCOPE = FrameBacktraceScopeNone;
        BACKTRACE_ONLY = FrameBacktraceScopeNone;
        SCOPE_ONLY = FrameNoneScopeFull;
        NO_FRAME_DUMMY_SCOPE = FrameNoneScopeDummy;
        NO_FRAME_NO_SCOPE = FrameNoneScopeNone;
    }
}

