/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceOfInstr
extends Instr
implements ResultInstr {
    private Class type;
    private String className;
    private Operand object;
    private Variable result;

    public InstanceOfInstr(Variable result2, Operand object, String className) {
        super(Operation.INSTANCE_OF);
        assert (result2 != null) : "InstanceOfInstr result is null";
        this.object = object;
        this.className = className;
        this.result = result2;
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new InstanceOfInstr(ii.getRenamedVariable(this.result), this.object.cloneForInlining(ii), this.className);
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.object};
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.object = this.object.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public String toString() {
        return (this.isDead() ? "[DEAD]" : "") + this.result + " = " + (Object)((Object)this.getOperation()) + "(" + this.object + ", " + this.className + ")";
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        try {
            if (this.type == null) {
                this.type = Class.forName(this.className);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return context.runtime.newBoolean(this.type.isInstance(this.object.retrieve(context, self, currDynScope, temp)));
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.InstanceOfInstr(this);
    }
}

