/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions.ruby18;

import org.jruby.Ruby;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReceiveRestArgBase;
import org.jruby.ir.instructions.RestArgMultipleAsgnInstr;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.builtin.IRubyObject;

public class ReceiveRestArgInstr18
extends ReceiveRestArgBase {
    private IRubyObject[] NO_PARAMS = new IRubyObject[0];

    public ReceiveRestArgInstr18(Variable result2, int argIndex) {
        super(result2, argIndex);
    }

    public Instr cloneForInlinedScope(InlinerInfo ii) {
        if (ii.canMapArgsStatically()) {
            return new CopyInstr(ii.getRenamedVariable(this.result), ii.getArg(this.argIndex, true));
        }
        return new RestArgMultipleAsgnInstr(ii.getRenamedVariable(this.result), ii.getArgs(), -1, -1, this.argIndex);
    }

    public Instr cloneForBlockCloning(InlinerInfo ii) {
        return new ReceiveRestArgInstr18(ii.getRenamedVariable(this.result), this.argIndex);
    }

    public IRubyObject receiveRestArg(Ruby runtime, IRubyObject[] parameters2) {
        IRubyObject[] args2;
        int available = parameters2.length - this.argIndex;
        if (available <= 0) {
            args2 = this.NO_PARAMS;
        } else {
            args2 = new IRubyObject[available];
            System.arraycopy(parameters2, this.argIndex, args2, 0, available);
        }
        return runtime.newArray(args2);
    }

    public void visit(IRVisitor visitor) {
        visitor.ReceiveRestArgInstr18(this);
    }
}

