/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.List;
import java.util.Map;
import org.jruby.RubyArray;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundArray
extends Operand {
    private final Operand a1;
    private final Operand a2;
    private boolean isArgsPush;

    public CompoundArray(Operand a1, Operand a2) {
        this(a1, a2, false);
    }

    public CompoundArray(Operand a1, Operand a2, boolean isArgsPush) {
        this.a1 = a1;
        this.a2 = a2;
        this.isArgsPush = isArgsPush;
    }

    @Override
    public boolean hasKnownValue() {
        return false;
    }

    public String toString() {
        return (this.isArgsPush ? "ArgsPush:[" : "ArgsCat:[") + this.a1 + ", " + this.a2 + "]";
    }

    public Operand getAppendedArg() {
        return this.a2;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap, boolean force) {
        Operand newA1 = this.a1.getSimplifiedOperand(valueMap, force);
        Operand newA2 = this.a2.getSimplifiedOperand(valueMap, force);
        return this.a1 == newA1 && this.a2 == newA2 ? this : new CompoundArray(newA1, newA2, this.isArgsPush);
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        this.a1.addUsedVariables(l);
        this.a2.addUsedVariables(l);
    }

    @Override
    public Operand cloneForInlining(InlinerInfo ii) {
        return this.hasKnownValue() ? this : new CompoundArray(this.a1.cloneForInlining(ii), this.a2.cloneForInlining(ii), this.isArgsPush);
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self, DynamicScope currDynScope, Object[] temp) {
        IRubyObject v1 = (IRubyObject)this.a1.retrieve(context, self, currDynScope, temp);
        IRubyObject v2 = (IRubyObject)this.a2.retrieve(context, self, currDynScope, temp);
        return this.isArgsPush ? RuntimeHelpers.argsPush((RubyArray)v1, v2) : RuntimeHelpers.argsCat(v1, v2);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.CompoundArray(this);
    }
}

