/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.List;
import java.util.Map;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.transformations.inlining.InlinerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Variable
extends Operand
implements Comparable {
    public static final String BLOCK = "%block";
    public static final String CURRENT_SCOPE = "%current_scope";
    public static final String CURRENT_MODULE = "%current_module";

    public abstract String getName();

    @Override
    public boolean canCopyPropagate() {
        return true;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap, boolean force) {
        Operand v = valueMap.get(this);
        return v != null && (force || v.canCopyPropagate()) ? v : this;
    }

    public boolean isImplicitBlockArg() {
        return this.getName().equals(BLOCK);
    }

    @Override
    public Operand getValue(Map<Operand, Operand> valueMap) {
        Operand v = valueMap.get(this);
        return v == null ? this : v;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        l.add(this);
    }

    public abstract Variable cloneForCloningClosure(InlinerInfo var1);

    @Override
    public Operand cloneForInlining(InlinerInfo ii) {
        return ii.getRenamedVariable(this);
    }
}

