/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ir.IRClosure;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.InterpretedIRBlockBody;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class InterpretedIRBlockBody19
extends InterpretedIRBlockBody {
    public InterpretedIRBlockBody19(IRClosure closure, Arity arity2, int argumentType) {
        super(closure, arity2, -1);
    }

    public String[] getParameterList() {
        return this.closure.getParameterList();
    }

    private IRubyObject[] convertValueIntoArgArray(ThreadContext context, IRubyObject value2, boolean passArrayArg, boolean argIsArray) {
        if (argIsArray && !(value2 instanceof RubyArray)) {
            argIsArray = false;
        }
        int blockArity = this.arity().getValue();
        switch (blockArity) {
            case 0: {
                return new IRubyObject[]{value2};
            }
            case -1: {
                IRubyObject[] iRubyObjectArray;
                if (argIsArray) {
                    iRubyObjectArray = ((RubyArray)value2).toJavaArray();
                } else {
                    IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
                    iRubyObjectArray = iRubyObjectArray2;
                    iRubyObjectArray2[0] = value2;
                }
                return iRubyObjectArray;
            }
            case 1: {
                if (argIsArray) {
                    RubyArray valArray = (RubyArray)value2;
                    if (valArray.size() == 0) {
                        value2 = passArrayArg ? RubyArray.newEmptyArray(context.runtime) : context.nil;
                    } else if (!passArrayArg) {
                        value2 = valArray.eltInternal(0);
                    }
                }
                return new IRubyObject[]{value2};
            }
        }
        if (argIsArray) {
            IRubyObject[] iRubyObjectArray;
            RubyArray valArray = (RubyArray)value2;
            if (valArray.size() == 1) {
                value2 = valArray.eltInternal(0);
            }
            if ((value2 = RuntimeHelpers.aryToAry(value2)) instanceof RubyArray) {
                iRubyObjectArray = ((RubyArray)value2).toJavaArray();
            } else {
                IRubyObject[] iRubyObjectArray3 = new IRubyObject[1];
                iRubyObjectArray = iRubyObjectArray3;
                iRubyObjectArray3[0] = value2;
            }
            return iRubyObjectArray;
        }
        if (!((value2 = RuntimeHelpers.aryToAry(value2)) instanceof RubyArray)) {
            throw context.runtime.newTypeError(value2.getType().getName() + "#to_ary should return Array");
        }
        return ((RubyArray)value2).toJavaArray();
    }

    private IRubyObject[] getLambdaArgs(ThreadContext context, IRubyObject value2, boolean passArrayArg, boolean argIsArray) {
        IRubyObject[] iRubyObjectArray;
        if (value2 == null) {
            iRubyObjectArray = IRubyObject.NULL_ARRAY;
        } else if (argIsArray) {
            iRubyObjectArray = ((RubyArray)value2).toJavaArray();
        } else {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
            iRubyObjectArray = iRubyObjectArray2;
            iRubyObjectArray2[0] = value2;
        }
        IRubyObject[] args2 = iRubyObjectArray;
        this.arity().checkArity(context.runtime, args2);
        return args2;
    }

    private IRubyObject[] getYieldArgs(ThreadContext context, IRubyObject value2, boolean passArrayArg, boolean argIsArray, Block.Type type2) {
        if (type2 == Block.Type.LAMBDA) {
            return this.getLambdaArgs(context, value2, passArrayArg, argIsArray);
        }
        return value2 == null ? IRubyObject.NULL_ARRAY : this.convertValueIntoArgArray(context, value2, passArrayArg, argIsArray);
    }

    public IRubyObject yieldSpecific(ThreadContext context, Binding binding2, Block.Type type2) {
        return this.yieldSpecificInternal(context, null, null, null, true, binding2, type2);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2) {
        return this.yieldSpecificInternal(context, arg0, null, null, true, binding2, type2);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Binding binding2, Block.Type type2) {
        return this.yieldSpecificInternal(context, context.runtime.newArrayNoCopyLight(arg0, arg1), null, null, true, binding2, type2);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Binding binding2, Block.Type type2) {
        return this.yieldSpecificInternal(context, context.runtime.newArrayNoCopyLight(arg0, arg1, arg2), null, null, true, binding2, type2);
    }

    private IRubyObject yieldSpecificInternal(ThreadContext context, IRubyObject value2, IRubyObject self, RubyModule klass, boolean argIsArray, Binding binding2, Block.Type type2) {
        IRubyObject[] args2 = this.getYieldArgs(context, value2, true, argIsArray, type2);
        return this.commonYieldPath(context, args2, self, klass, binding2, type2, Block.NULL_BLOCK);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value2, IRubyObject self, RubyModule klass, boolean argIsArray, Binding binding2, Block.Type type2) {
        IRubyObject[] args2 = this.getYieldArgs(context, value2, false, argIsArray, type2);
        return this.commonYieldPath(context, args2, self, klass, binding2, type2, Block.NULL_BLOCK);
    }

    public IRubyObject[] prepareArgumentsForCall(ThreadContext context, IRubyObject[] args2, Block.Type type2) {
        if (type2 == Block.Type.LAMBDA) {
            this.arity().checkArity(context.runtime, args2);
        } else if (args2.length == 1) {
            args2 = this.convertValueIntoArgArray(context, args2[0], true, type2 == Block.Type.NORMAL && args2[0] instanceof RubyArray);
        } else if (this.arity().getValue() == 1) {
            IRubyObject[] iRubyObjectArray;
            if (args2.length == 0) {
                iRubyObjectArray = context.runtime.getSingleNilArray();
            } else {
                IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
                iRubyObjectArray = iRubyObjectArray2;
                iRubyObjectArray2[0] = args2[0];
            }
            args2 = iRubyObjectArray;
        }
        return args2;
    }
}

