/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class JavaInternalBlockBody
extends BlockBody {
    private final Arity arity;
    private final ThreadContext originalContext;
    private final String methodName;

    public JavaInternalBlockBody(Arity arity2) {
        this(null, null, arity2);
    }

    public JavaInternalBlockBody(ThreadContext originalContext, String methodName, Arity arity2) {
        super(3);
        this.arity = arity2;
        this.originalContext = originalContext;
        this.methodName = methodName;
    }

    private void threadCheck(ThreadContext yieldingContext) {
        if (this.originalContext != null && yieldingContext != this.originalContext) {
            throw yieldingContext.runtime.newThreadError("" + this.methodName + " cannot be parallelized");
        }
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        IRubyObject value2 = args2.length == 1 ? args2[0] : RubyArray.newArrayNoCopy(context.runtime, args2);
        return this.yield(context, value2, null, null, true, binding2, type2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2, Block block) {
        IRubyObject value2 = args2.length == 1 ? args2[0] : RubyArray.newArrayNoCopy(context.runtime, args2);
        return this.yield(context, value2, null, null, true, binding2, type2, block);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        this.threadCheck(context);
        return this.yield(context, value2);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value2, IRubyObject self, RubyModule klass, boolean aValue, Binding binding2, Block.Type type2) {
        this.threadCheck(context);
        return this.yield(context, value2);
    }

    public abstract IRubyObject yield(ThreadContext var1, IRubyObject var2);

    public StaticScope getStaticScope() {
        throw new RuntimeException("CallBlock does not have a static scope; this should not be called");
    }

    public void setStaticScope(StaticScope newScope) {
        throw new RuntimeException("CallBlock does not have a static scope; this should not be called");
    }

    public Block cloneBlock(Binding binding2) {
        return new Block(this, binding2);
    }

    public Arity arity() {
        return this.arity;
    }

    public String getFile() {
        return "(internal)";
    }

    public int getLine() {
        return -1;
    }
}

