/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.HashMap;
import java.util.Map;
import org.jruby.RubyInstanceConfig;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.callsite.BitAndCallSite;
import org.jruby.runtime.callsite.BitOrCallSite;
import org.jruby.runtime.callsite.CmpCallSite;
import org.jruby.runtime.callsite.EqCallSite;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;
import org.jruby.runtime.callsite.GeCallSite;
import org.jruby.runtime.callsite.GtCallSite;
import org.jruby.runtime.callsite.LeCallSite;
import org.jruby.runtime.callsite.LtCallSite;
import org.jruby.runtime.callsite.MinusCallSite;
import org.jruby.runtime.callsite.MulCallSite;
import org.jruby.runtime.callsite.NormalCachingCallSite;
import org.jruby.runtime.callsite.PlusCallSite;
import org.jruby.runtime.callsite.RespondToCallSite;
import org.jruby.runtime.callsite.ShiftLeftCallSite;
import org.jruby.runtime.callsite.ShiftRightCallSite;
import org.jruby.runtime.callsite.SuperCallSite;
import org.jruby.runtime.callsite.VariableCachingCallSite;
import org.jruby.runtime.callsite.XorCallSite;

public class MethodIndex {
    public static final int NO_METHOD = 0;
    public static final int OP_EQUAL = 1;
    public static final int EQL = 2;
    public static final int HASH = 3;
    public static final int OP_CMP = 4;
    public static final int MAX_METHODS = 5;
    public static final String[] METHOD_NAMES = new String[]{"", "==", "eql?", "hash", "<=>"};
    private static final Map<String, String> FIXNUM_OPS = new HashMap<String, String>();
    private static final String[][] fastFixnumOps;
    private static final Map<String, String> FLOAT_OPS;
    private static final String[][] fastFloatOps;

    public static CallSite getCallSite(String name2) {
        if (name2.equals("respond_to?")) {
            return new RespondToCallSite();
        }
        if (RubyInstanceConfig.FASTOPS_COMPILE_ENABLED && !RubyInstanceConfig.FULL_TRACE_ENABLED) {
            return MethodIndex.getFastFixnumOpsCallSite(name2);
        }
        return new NormalCachingCallSite(name2);
    }

    public static boolean hasFastFixnumOps(String name2) {
        return FIXNUM_OPS.containsKey(name2);
    }

    public static String getFastFixnumOpsMethod(String name2) {
        return FIXNUM_OPS.get(name2);
    }

    public static CallSite getFastFixnumOpsCallSite(String name2) {
        if (name2.equals("+")) {
            return new PlusCallSite();
        }
        if (name2.equals("-")) {
            return new MinusCallSite();
        }
        if (name2.equals("*")) {
            return new MulCallSite();
        }
        if (name2.equals("<")) {
            return new LtCallSite();
        }
        if (name2.equals("<=")) {
            return new LeCallSite();
        }
        if (name2.equals(">")) {
            return new GtCallSite();
        }
        if (name2.equals(">=")) {
            return new GeCallSite();
        }
        if (name2.equals("==")) {
            return new EqCallSite();
        }
        if (name2.equals("<=>")) {
            return new CmpCallSite();
        }
        if (name2.equals("&")) {
            return new BitAndCallSite();
        }
        if (name2.equals("|")) {
            return new BitOrCallSite();
        }
        if (name2.equals("^")) {
            return new XorCallSite();
        }
        if (name2.equals(">>")) {
            return new ShiftRightCallSite();
        }
        if (name2.equals("<<")) {
            return new ShiftLeftCallSite();
        }
        return new NormalCachingCallSite(name2);
    }

    public static boolean hasFastFloatOps(String name2) {
        return FLOAT_OPS.containsKey(name2);
    }

    public static String getFastFloatOpsMethod(String name2) {
        return FLOAT_OPS.get(name2);
    }

    public static CallSite getFastFloatOpsCallSite(String name2) {
        if (name2.equals("+")) {
            return new PlusCallSite();
        }
        if (name2.equals("-")) {
            return new MinusCallSite();
        }
        if (name2.equals("*")) {
            return new MulCallSite();
        }
        if (name2.equals("<")) {
            return new LtCallSite();
        }
        if (name2.equals("<=")) {
            return new LeCallSite();
        }
        if (name2.equals(">")) {
            return new GtCallSite();
        }
        if (name2.equals(">=")) {
            return new GeCallSite();
        }
        if (name2.equals("==")) {
            return new EqCallSite();
        }
        if (name2.equals("<=>")) {
            return new CmpCallSite();
        }
        return new NormalCachingCallSite(name2);
    }

    public static CallSite getFunctionalCallSite(String name2) {
        return new FunctionalCachingCallSite(name2);
    }

    public static CallSite getVariableCallSite(String name2) {
        return new VariableCachingCallSite(name2);
    }

    public static CallSite getSuperCallSite() {
        return new SuperCallSite();
    }

    static {
        for (String[] fastOp : fastFixnumOps = new String[][]{{"+", "op_plus"}, {"-", "op_minus"}, {"*", "op_mul"}, {"==", "op_equal"}, {"<", "op_lt"}, {"<=", "op_le"}, {">", "op_gt"}, {">=", "op_ge"}, {"<=>", "op_cmp"}, {"&", "op_and"}, {"|", "op_or"}, {"^", "op_xor"}, {">>", "op_rshift"}, {"<<", "op_lshift"}}) {
            FIXNUM_OPS.put(fastOp[0], fastOp[1]);
        }
        FLOAT_OPS = new HashMap<String, String>();
        fastFloatOps = new String[][]{{"+", "op_plus"}, {"-", "op_minus"}, {"*", "op_mul"}, {"==", "op_equal"}, {"<", "op_lt"}, {"<=", "op_le"}, {">", "op_gt"}, {">=", "op_ge"}, {"<=>", "op_cmp"}};
        for (String[] fastOp : fastFloatOps) {
            FLOAT_OPS.put(fastOp[0], fastOp[1]);
        }
    }
}

