/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile;

import org.jruby.util.collections.IntHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invocation {
    private final int methodSerialNumber;
    private int recursiveDepth;
    private Invocation parent;
    private final IntHashMap<Invocation> children;
    private long duration = 0L;
    private int count = 0;

    public Invocation(int serial2) {
        this(null, serial2);
    }

    public Invocation(Invocation parent, int serial2) {
        this.parent = parent;
        this.methodSerialNumber = serial2;
        this.children = new IntHashMap();
    }

    public Invocation(Invocation parent, int serial2, IntHashMap<Invocation> children) {
        this.parent = parent;
        this.methodSerialNumber = serial2;
        this.children = children;
    }

    public int getMethodSerialNumber() {
        return this.methodSerialNumber;
    }

    public int getRecursiveDepth() {
        return this.recursiveDepth;
    }

    public void setRecursiveDepth(int d) {
        this.recursiveDepth = d;
    }

    public Invocation getParent() {
        return this.parent;
    }

    public void setParent(Invocation p2) {
        this.parent = p2;
    }

    public IntHashMap<Invocation> getChildren() {
        return this.children;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long d) {
        this.duration = d;
    }

    public void addDuration(long d) {
        this.duration += d;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int c) {
        this.count = c;
    }

    public void incrementCount() {
        ++this.count;
    }

    public Invocation childInvocationFor(int serial2) {
        Invocation child = this.children.get(serial2);
        if (child == null) {
            child = new Invocation(this, serial2);
            this.children.put(serial2, child);
        }
        return child;
    }

    Invocation copyWithNewSerialAndParent(int serial2, Invocation newParent) {
        Invocation newInv = new Invocation(newParent, serial2, this.children);
        newInv.setDuration(this.duration);
        newInv.setCount(this.count);
        newInv.setRecursiveDepth(this.recursiveDepth);
        for (Invocation child : this.children.values()) {
            child.setParent(newInv);
        }
        return newInv;
    }

    public void addChild(Invocation child) {
        this.children.put(child.getMethodSerialNumber(), child);
    }

    public long childTime() {
        long t = 0L;
        for (Invocation inv : this.children.values()) {
            t += inv.getDuration();
        }
        return t;
    }

    public long selfTime() {
        return this.duration - this.childTime();
    }

    public String toString() {
        return "Invocation(#" + this.methodSerialNumber + " count=" + this.count + " duration=" + this.duration + " parent=" + (this.parent == null ? null : "#" + this.parent.methodSerialNumber) + " children.size=" + this.children.size() + ")";
    }
}

