/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile;

import java.util.List;
import org.jruby.runtime.profile.Invocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InvocationSet {
    final List<Invocation> invocations;

    InvocationSet(List<Invocation> invocations) {
        this.invocations = invocations;
    }

    public long totalTime() {
        long t = 0L;
        for (Invocation inv : this.invocations) {
            t += inv.getDuration();
        }
        return t;
    }

    public long selfTime() {
        return this.totalTime() - this.childTime();
    }

    public long childTime() {
        long t = 0L;
        for (Invocation inv : this.invocations) {
            t += inv.childTime();
        }
        return t;
    }

    public int totalCalls() {
        int t = 0;
        for (Invocation inv : this.invocations) {
            t += inv.getCount();
        }
        return t;
    }

    public long timeSpentInChild(int serial2) {
        long t = 0L;
        for (Invocation inv : this.invocations) {
            Invocation childInv = inv.getChildren().get(serial2);
            if (childInv == null) continue;
            t += childInv.getDuration();
        }
        return t;
    }

    public int callsOfChild(int serial2) {
        int c = 0;
        for (Invocation inv : this.invocations) {
            Invocation childInv = inv.getChildren().get(serial2);
            if (childInv == null) continue;
            c += childInv.getCount();
        }
        return c;
    }
}

