/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.collections;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.IdentityHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakValuedIdentityMap<Key, Value> {
    private final ReferenceQueue deadReferences = new ReferenceQueue();
    private final Map<Key, KeyedReference<Key, Value>> references = new IdentityHashMap<Key, KeyedReference<Key, Value>>();

    public synchronized void put(Key key2, Value value2) {
        this.cleanReferences();
        this.references.put(key2, new KeyedReference<Key, Value>(value2, key2, this.deadReferences));
    }

    public synchronized Value get(Key key2) {
        this.cleanReferences();
        KeyedReference<Key, Value> reference2 = this.references.get(key2);
        if (reference2 == null) {
            return null;
        }
        return (Value)reference2.get();
    }

    private void cleanReferences() {
        KeyedReference ref;
        while ((ref = (KeyedReference)this.deadReferences.poll()) != null) {
            this.references.remove(ref.key());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyedReference<Key, Value>
    extends WeakReference<Value> {
        private final Key key;

        public KeyedReference(Value object, Key key2, ReferenceQueue queue) {
            super(object, queue);
            this.key = key2;
        }

        public Key key() {
            return this.key;
        }
    }
}

