/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class SClassNode
extends Node {
    private final Node receiverNode;
    private final StaticScope scope;
    private final Node bodyNode;

    public SClassNode(ISourcePosition position, Node recvNode, StaticScope scope, Node bodyNode) {
        super(position);
        assert (scope != null) : "scope is not null";
        assert (recvNode != null) : "receiverNode is not null";
        this.receiverNode = recvNode;
        this.scope = scope;
        this.bodyNode = bodyNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SCLASSNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitSClassNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public StaticScope getScope() {
        return this.scope;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.bodyNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        IRubyObject receiver2 = this.receiverNode.interpret(runtime, context, self2, aBlock);
        RubyClass singletonClass = Helpers.getSingletonClass(runtime, receiver2);
        this.scope.setModule(singletonClass);
        return ASTInterpreter.evalClassDefinitionBody(runtime, context, this.scope, this.bodyNode, singletonClass, self2, aBlock);
    }
}

