/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.Ruby;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReceiveArgBase;
import org.jruby.ir.instructions.RestArgMultipleAsgnInstr;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.builtin.IRubyObject;

public class ReceiveRestArgInstr
extends ReceiveArgBase {
    public final int numUsedArgs;
    private IRubyObject[] NO_PARAMS = new IRubyObject[0];

    public ReceiveRestArgInstr(Variable result2, int numUsedArgs, int argIndex) {
        super(Operation.RECV_REST_ARG, result2, argIndex);
        this.numUsedArgs = numUsedArgs;
    }

    @Override
    public String toString() {
        return (this.isDead() ? "[DEAD]" : "") + (this.hasUnusedResult() ? "[DEAD-RESULT]" : "") + this.getResult() + " = " + (Object)((Object)this.getOperation()) + "(" + this.numUsedArgs + ", " + this.argIndex + ")";
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        if (ii.canMapArgsStatically()) {
            return new CopyInstr(ii.getRenamedVariable(this.result), ii.getArg(this.argIndex, true));
        }
        return new RestArgMultipleAsgnInstr(ii.getRenamedVariable(this.result), ii.getArgs(), this.argIndex, this.numUsedArgs - this.argIndex, this.argIndex);
    }

    @Override
    public Instr cloneForBlockCloning(InlinerInfo ii) {
        return new ReceiveRestArgInstr(ii.getRenamedVariable(this.result), this.numUsedArgs, this.argIndex);
    }

    public IRubyObject receiveRestArg(Ruby runtime, IRubyObject[] parameters2, int kwArgLoss) {
        IRubyObject[] args2;
        int numAvailableArgs = parameters2.length - this.numUsedArgs - kwArgLoss;
        if (numAvailableArgs <= 0) {
            args2 = this.NO_PARAMS;
        } else {
            args2 = new IRubyObject[numAvailableArgs];
            System.arraycopy(parameters2, this.argIndex, args2, 0, numAvailableArgs);
        }
        return runtime.newArray(args2);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ReceiveRestArgInstr(this);
    }
}

