/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed;

import java.net.URL;
import java.util.Arrays;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.ScriptingContainer;
import org.osgi.framework.Bundle;

public class IsolatedScriptingContainer
extends ScriptingContainer {
    private static final String JRUBYDIR = "/.jrubydir";
    private static final String JRUBY_HOME = "/META-INF/jruby.home";

    public IsolatedScriptingContainer() {
        this(LocalContextScope.SINGLETON);
    }

    public IsolatedScriptingContainer(LocalContextScope scope, LocalVariableBehavior behavior) {
        this(scope, behavior, true);
    }

    public IsolatedScriptingContainer(LocalContextScope scope) {
        this(scope, LocalVariableBehavior.TRANSIENT);
    }

    public IsolatedScriptingContainer(LocalVariableBehavior behavior) {
        this(LocalContextScope.SINGLETON, behavior);
    }

    public IsolatedScriptingContainer(LocalContextScope scope, LocalVariableBehavior behavior, boolean lazy) {
        super(scope, behavior, lazy);
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        this.setClassLoader(cl);
        this.setLoadPaths(Arrays.asList("uri:classloader:"));
        this.setHomeDirectory("uri:classloader:/META-INF/jruby.home");
        this.runScriptlet("require 'rubygems/defaults/jruby';Gem::Specification.reset;Gem::Specification.add_dir 'uri:classloader:/META-INF/jruby.home/lib/ruby/gems/shared';Gem::Specification.add_dir 'uri:classloader:';");
    }

    public void addLoadPath(ClassLoader cl) {
        this.addLoadPath(cl, JRUBYDIR);
    }

    public void addLoadPath(ClassLoader cl, String ref) {
        this.addLoadPath(this.createUri(cl, ref));
    }

    public void addBundleToLoadPath(Bundle cl) {
        this.addBundleToLoadPath(cl, JRUBYDIR);
    }

    public void addBundleToLoadPath(Bundle cl, String ref) {
        this.addLoadPath(this.createUriFromBundle(cl, ref));
    }

    private String createUriFromBundle(Bundle cl, String ref) {
        URL url = cl.getResource(ref);
        if (url == null && ref.startsWith("/")) {
            url = cl.getResource(ref.substring(1));
        }
        if (url == null) {
            throw new RuntimeException("reference " + ref + " not found on bundle " + cl);
        }
        return "uri:" + url.toString().replaceFirst(ref + "$", "");
    }

    private void addLoadPath(String uri) {
        this.runScriptlet("$LOAD_PATH << '" + uri + "' unless $LOAD_PATH.member?( '" + uri + "' )");
    }

    public void addBundleToGemPath(Bundle cl) {
        this.addBundleToGemPath(cl, "/specifications/.jrubydir");
    }

    public void addBundleToGemPath(Bundle cl, String ref) {
        this.addGemPath(this.createUriFromBundle(cl, ref));
    }

    public void addGemPath(ClassLoader cl) {
        this.addGemPath(cl, "/specifications/.jrubydir");
    }

    public void addGemPath(ClassLoader cl, String ref) {
        this.addGemPath(this.createUri(cl, ref));
    }

    private String createUri(ClassLoader cl, String ref) {
        URL url = cl.getResource(ref);
        if (url == null && ref.startsWith("/")) {
            url = cl.getResource(ref.substring(1));
        }
        if (url == null) {
            throw new RuntimeException("reference " + ref + " not found on classloader " + cl);
        }
        return "uri:" + url.toString().replaceFirst(ref + "$", "");
    }

    private void addGemPath(String uri) {
        this.runScriptlet("Gem::Specification.add_dir '" + uri + "' unless Gem::Specification.dirs.member?( '" + uri + "' )");
    }
}

