/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyLocalJumpError;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;

public class IRException
extends Operand {
    private String exceptionType;
    public static final IRException RETRY_LocalJumpError = new IRException("LocalJumpError: retry outside of rescue not supported");
    public static final IRException NEXT_LocalJumpError = new IRException("LocalJumpError: unexpected next");
    public static final IRException BREAK_LocalJumpError = new IRException("LocalJumpError: unexpected break");
    public static final IRException RETURN_LocalJumpError = new IRException("LocalJumpError: unexpected return");
    public static final IRException REDO_LocalJumpError = new IRException("LocalJumpError: unexpected redo");

    protected IRException(String exceptionType) {
        this.exceptionType = exceptionType;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
    }

    @Override
    public Operand cloneForInlining(InlinerInfo ii) {
        return this;
    }

    @Override
    public boolean canCopyPropagate() {
        return true;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder("LocalJumpError:");
        if (this == NEXT_LocalJumpError) {
            result2.append("NEXT");
        } else if (this == BREAK_LocalJumpError) {
            result2.append("BREAK");
        } else if (this == RETURN_LocalJumpError) {
            result2.append("RETURN");
        } else if (this == REDO_LocalJumpError) {
            result2.append("REDO");
        } else if (this == RETRY_LocalJumpError) {
            result2.append("RETRY");
        }
        return result2.toString();
    }

    public RuntimeException getException(Ruby runtime) {
        if (this == NEXT_LocalJumpError) {
            return runtime.newLocalJumpError(RubyLocalJumpError.Reason.NEXT, null, "unexpected next");
        }
        if (this == BREAK_LocalJumpError) {
            return runtime.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, null, "unexpected break");
        }
        if (this == RETURN_LocalJumpError) {
            return runtime.newLocalJumpError(RubyLocalJumpError.Reason.RETURN, null, "unexpected return");
        }
        if (this == REDO_LocalJumpError) {
            return runtime.newLocalJumpError(RubyLocalJumpError.Reason.REDO, null, "unexpected redo");
        }
        if (this == RETRY_LocalJumpError) {
            return runtime.newLocalJumpError(RubyLocalJumpError.Reason.RETRY, null, "retry outside of rescue not supported");
        }
        throw new RuntimeException("Unhandled case in operands/IRException.java");
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.IRException(this);
    }
}

