/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.ast.BinaryOperatorNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.DefinedMessage;

public class OpAsgnOrNode
extends Node
implements BinaryOperatorNode {
    private final Node firstNode;
    private final Node secondNode;

    public OpAsgnOrNode(ISourcePosition position, Node headNode, Node valueNode) {
        super(position);
        assert (headNode != null) : "headNode is not null";
        assert (valueNode != null) : "valueNode is not null";
        this.firstNode = headNode;
        this.secondNode = valueNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.OPASGNORNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitOpAsgnOrNode(this);
    }

    @Override
    public Node getFirstNode() {
        return this.firstNode;
    }

    @Override
    public Node getSecondNode() {
        return this.secondNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.firstNode, this.secondNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        IRubyObject result2 = runtime.getNil();
        if (this.defined(runtime, context, this.firstNode, self2, aBlock)) {
            result2 = this.firstNode.interpret(runtime, context, self2, aBlock);
        }
        if (!result2.isTrue()) {
            result2 = this.secondNode.interpret(runtime, context, self2, aBlock);
        }
        return ASTInterpreter.pollAndReturn(context, result2);
    }

    private boolean defined(Ruby runtime, ThreadContext context, Node node, IRubyObject self2, Block aBlock) {
        return node.definition(runtime, context, self2, aBlock) != null;
    }

    @Override
    public RubyString definition(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        try {
            this.interpret(runtime, context, self2, aBlock);
            return runtime.getDefinedMessage(DefinedMessage.ASSIGNMENT);
        }
        catch (JumpException jumpException) {
            return null;
        }
    }
}

