/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ripper;

import java.io.IOException;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.ext.ripper.LexerSource;
import org.jruby.ext.ripper.Position;
import org.jruby.ext.ripper.RipperLexer;
import org.jruby.ext.ripper.StrTerm;
import org.jruby.ext.ripper.SyntaxException;
import org.jruby.ext.ripper.Warnings;
import org.jruby.lexer.yacc.StackState;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class RipperParser {
    protected IRubyObject ripper;
    protected ThreadContext context;
    protected RipperLexer lexer;
    protected StaticScope currentScope;
    protected boolean inDefinition;
    protected int inSingleton;

    public RipperParser(ThreadContext context, IRubyObject ripper2, LexerSource source2) {
        this.context = context;
        this.ripper = ripper2;
        this.lexer = new RipperLexer(this, source2);
    }

    static int associateEncoding(ByteList buffer, Encoding ASCII8BIT_ENCODING, int codeRange) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void reset() {
    }

    public Object yyparse(RipperLexer yyLex) throws IOException {
        return null;
    }

    public Object yyparse(RipperLexer yyLex, Object debugger) throws IOException {
        return null;
    }

    public IRubyObject parse(boolean isDebug) throws IOException {
        this.reset();
        Object debugger = null;
        return (IRubyObject)this.yyparse(this.lexer, debugger);
    }

    public IRubyObject arg_add_optblock(IRubyObject arg1, IRubyObject arg2) {
        if (arg2 == null) {
            return arg1;
        }
        return this.dispatch("on_args_add_block", arg1, arg2);
    }

    public IRubyObject arg_var(IRubyObject identifier) {
        String name2 = this.lexer.getIdent();
        StaticScope current2 = this.getCurrentScope();
        if (name2 == "_") {
            int count2 = 0;
            while (current2.exists(name2) >= 0) {
                name2 = "_$" + count2++;
            }
        }
        current2.addVariableThisScope(name2);
        return identifier;
    }

    public IRubyObject assignable(IRubyObject name2) {
        return name2;
    }

    public IRubyObject dispatch(String method_name) {
        return Helpers.invoke(this.context, this.ripper, method_name);
    }

    public IRubyObject dispatch(String method_name, IRubyObject arg1) {
        return Helpers.invoke(this.context, this.ripper, method_name, this.escape(arg1));
    }

    public IRubyObject dispatch(String method_name, IRubyObject arg1, IRubyObject arg2) {
        return Helpers.invoke(this.context, this.ripper, method_name, this.escape(arg1), this.escape(arg2));
    }

    public IRubyObject dispatch(String method_name, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return Helpers.invoke(this.context, this.ripper, method_name, this.escape(arg1), this.escape(arg2), this.escape(arg3));
    }

    public IRubyObject dispatch(String method_name, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4) {
        return Helpers.invoke(this.context, this.ripper, method_name, this.escape(arg1), this.escape(arg2), this.escape(arg3), this.escape(arg4));
    }

    public IRubyObject dispatch(String method_name, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5) {
        return Helpers.invoke(this.context, this.ripper, method_name, this.escape(arg1), this.escape(arg2), this.escape(arg3), this.escape(arg4), this.escape(arg5));
    }

    public IRubyObject escape(IRubyObject arg2) {
        return arg2 == null ? this.context.runtime.getNil() : arg2;
    }

    public IRubyObject formal_argument(IRubyObject identifier) {
        return this.shadowing_lvar(identifier);
    }

    protected void getterIdentifierError(Position position, String identifier) {
        throw new SyntaxException(SyntaxException.PID.BAD_IDENTIFIER, position, this.lexer.getCurrentLine(), "identifier " + identifier + " is not valid", identifier);
    }

    public boolean is_id_var(IRubyObject identifier) {
        String ident = this.lexer.getIdent();
        ident.intern();
        char c = ident.charAt(0);
        if (c == '$' || c == '@' || Character.toUpperCase(c) == c) {
            return false;
        }
        return this.getCurrentScope().getLocalScope().isDefined(ident) >= 0;
    }

    public boolean is_local_id(String identifier) {
        return this.lexer.isIdentifierChar(identifier.charAt(0));
    }

    public IRubyObject intern(String value2) {
        return this.context.runtime.newSymbol(value2);
    }

    public IRubyObject method_optarg(IRubyObject method2, IRubyObject arg2) {
        if (arg2 == null) {
            return method2;
        }
        return this.dispatch("on_method_add_arg", method2, arg2);
    }

    public IRubyObject new_array(IRubyObject arg2) {
        return this.context.runtime.newArray(arg2);
    }

    public IRubyObject new_assoc(IRubyObject key2, IRubyObject value2) {
        RubyHash hash2 = RubyHash.newHash(this.context.runtime);
        hash2.fastASet(value2, value2);
        return hash2;
    }

    public IRubyObject new_bv(IRubyObject identifier) {
        String ident = this.lexer.getIdent();
        if (!this.is_local_id(ident)) {
            this.getterIdentifierError(this.lexer.getPosition(), ident);
        }
        return this.arg_var(this.shadowing_lvar(identifier));
    }

    public void popCurrentScope() {
        this.currentScope = this.currentScope.getEnclosingScope();
    }

    public void pushBlockScope() {
        this.currentScope = this.getRuntime().getStaticScopeFactory().newBlockScope(this.currentScope);
    }

    public void pushLocalScope() {
        this.currentScope = this.getRuntime().getStaticScopeFactory().newLocalScope(this.currentScope);
    }

    public void setCommandStart(boolean value2) {
        this.lexer.commandStart = value2;
    }

    public IRubyObject shadowing_lvar(IRubyObject identifier) {
        String name2 = this.lexer.getIdent();
        if (name2 == "_") {
            return identifier;
        }
        StaticScope current2 = this.getCurrentScope();
        if (current2.isBlockScope()) {
            if (current2.exists(name2) >= 0) {
                this.yyerror("duplicated argument name");
            }
            if (this.lexer.isVerbose() && current2.isDefined(name2) >= 0) {
                this.lexer.warning(Warnings.ID.STATEMENT_NOT_REACHED, this.lexer.getPosition(), "shadowing outer local variable - " + name2);
            }
        } else if (current2.exists(name2) >= 0) {
            this.yyerror("duplicated argument name");
        }
        return identifier;
    }

    public StackState getConditionState() {
        return this.lexer.getConditionState();
    }

    public Position getPosition() {
        return this.lexer.getPosition();
    }

    public boolean isInDef() {
        return this.inDefinition;
    }

    public boolean isInSingle() {
        return this.inSingleton != 0;
    }

    public StrTerm getStrTerm() {
        return this.lexer.getStrTerm();
    }

    public void setStrTerm(StrTerm object) {
        this.lexer.setStrTerm(object);
    }

    public StackState getCmdArgumentState() {
        return this.lexer.getCmdArgumentState();
    }

    public void yyerror(String message2) {
        throw new SyntaxException(SyntaxException.PID.GRAMMAR_ERROR, this.lexer.getPosition(), this.lexer.getCurrentLine(), message2, new Object[0]);
    }

    public void yyerror(String message2, String[] expected, String found) {
        String text = message2 + ", unexpected " + found + "\n";
        this.dispatch("on_parse_error", this.getRuntime().newString(text));
        throw new SyntaxException(SyntaxException.PID.CHARACTER_BAD, this.lexer.getPosition(), found, message2, expected);
    }

    public Integer getLeftParenBegin() {
        return this.lexer.getLeftParenBegin();
    }

    public void setLeftParenBegin(Integer integer) {
        this.lexer.setLeftParenBegin(integer);
    }

    public void setInDef(boolean inDefinition) {
        this.inDefinition = inDefinition;
    }

    public void setInSingle(int inSingleton) {
        this.inSingleton = inSingleton;
    }

    public int getInSingle() {
        return this.inSingleton;
    }

    public void setState(RipperLexer.LexState lexState) {
        this.lexer.setState(lexState);
    }

    public void warning(Warnings.ID id2, Position position, String message2) {
        if (this.lexer.isVerbose()) {
            this.lexer.warning(id2, position, message2);
        }
    }

    public void warn(Warnings.ID id2, Position position, String message2) {
        this.lexer.warn(id2, position, message2);
    }

    public Integer incrementParenNest() {
        return this.lexer.incrementParenNest();
    }

    public StaticScope getCurrentScope() {
        return this.currentScope;
    }

    public Ruby getRuntime() {
        return this.context.runtime;
    }

    public long getColumn() {
        return this.lexer.getEventLocation().getStartOffset();
    }

    public long getLineno() {
        return this.lexer.getEventLocation().getStartLine() + 1;
    }
}

