/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import jnr.constants.platform.IPProto;
import jnr.constants.platform.ProtocolFamily;
import jnr.constants.platform.Sock;
import jnr.constants.platform.SocketLevel;
import jnr.constants.platform.SocketOption;
import jnr.constants.platform.TCP;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.Addrinfo;
import org.jruby.ext.socket.MulticastStateManager;
import org.jruby.ext.socket.Option;
import org.jruby.ext.socket.SocketType;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Pack;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ChannelStream;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;
import org.jruby.util.io.Sockaddr;

@JRubyClass(name={"BasicSocket"}, parent="IO")
public class RubyBasicSocket
extends RubyIO {
    private static ObjectAllocator BASICSOCKET_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyBasicSocket(runtime, klass);
        }
    };
    private static final ByteList FORMAT_SMALL_I = new ByteList(ByteList.plain("i"));
    protected MulticastStateManager multicastStateManager = null;
    private boolean doNotReverseLookup = false;

    static void createBasicSocket(Ruby runtime) {
        RubyClass rb_cBasicSocket = runtime.defineClass("BasicSocket", runtime.getIO(), BASICSOCKET_ALLOCATOR);
        rb_cBasicSocket.defineAnnotatedMethods(RubyBasicSocket.class);
    }

    public RubyBasicSocket(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
        this.doNotReverseLookup = runtime.is1_9();
    }

    @JRubyMethod(name={"do_not_reverse_lookup"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject do_not_reverse_lookup19(ThreadContext context) {
        return context.runtime.newBoolean(this.doNotReverseLookup);
    }

    @JRubyMethod(name={"do_not_reverse_lookup="}, compat=CompatVersion.RUBY1_9)
    public IRubyObject set_do_not_reverse_lookup19(ThreadContext context, IRubyObject flag) {
        this.doNotReverseLookup = flag.isTrue();
        return this.do_not_reverse_lookup19(context);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject do_not_reverse_lookup(ThreadContext context, IRubyObject recv2) {
        return context.runtime.newBoolean(context.runtime.isDoNotReverseLookupEnabled());
    }

    @JRubyMethod(name={"do_not_reverse_lookup="}, meta=true)
    public static IRubyObject set_do_not_reverse_lookup(ThreadContext context, IRubyObject recv2, IRubyObject flag) {
        context.runtime.setDoNotReverseLookupEnabled(flag.isTrue());
        return flag;
    }

    @JRubyMethod(name={"send"})
    public IRubyObject send(ThreadContext context, IRubyObject _mesg, IRubyObject _flags) {
        return this.syswrite(context, _mesg);
    }

    @JRubyMethod(name={"send"})
    public IRubyObject send(ThreadContext context, IRubyObject _mesg, IRubyObject _flags, IRubyObject _to) {
        return this.send(context, _mesg, _flags);
    }

    @Deprecated
    public IRubyObject recv(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.recv(context, args2[0]);
            }
            case 2: {
                return this.recv(context, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context.runtime, args2, 1, 2);
        return null;
    }

    @JRubyMethod
    public IRubyObject recv(ThreadContext context, IRubyObject _length) {
        Ruby runtime = context.runtime;
        ByteList bytes2 = this.doReceive(context, RubyNumeric.fix2int(_length));
        if (bytes2 == null) {
            return context.nil;
        }
        return RubyString.newString(runtime, bytes2);
    }

    @JRubyMethod
    public IRubyObject recv(ThreadContext context, IRubyObject _length, IRubyObject _flags) {
        return this.recv(context, _length);
    }

    @JRubyMethod
    public IRubyObject recv_nonblock(ThreadContext context, IRubyObject _length) {
        Ruby runtime = context.runtime;
        ByteList bytes2 = this.doReceiveNonblock(context, RubyNumeric.fix2int(_length));
        if (bytes2 == null) {
            if (runtime.is1_9()) {
                throw runtime.newErrnoEAGAINReadableError("recvfrom(2)");
            }
            throw runtime.newErrnoEAGAINError("recvfrom(2)");
        }
        return RubyString.newString(runtime, bytes2);
    }

    @JRubyMethod
    public IRubyObject recv_nonblock(ThreadContext context, IRubyObject _length, IRubyObject _flags) {
        return this.recv_nonblock(context, _length);
    }

    @JRubyMethod
    public IRubyObject getsockopt(ThreadContext context, IRubyObject _level, IRubyObject _opt) {
        Ruby runtime = context.runtime;
        SocketLevel level2 = RubyBasicSocket.levelFromArg(_level);
        SocketOption opt = RubyBasicSocket.optionFromArg(_opt);
        int value2 = 0;
        try {
            Channel channel = this.getOpenChannel();
            switch (level2) {
                case SOL_SOCKET: 
                case SOL_IP: 
                case SOL_TCP: 
                case SOL_UDP: {
                    if (opt == SocketOption.__UNKNOWN_CONSTANT__) {
                        throw runtime.newErrnoENOPROTOOPTError();
                    }
                    value2 = SocketType.forChannel(channel).getSocketOption(channel, opt);
                    if (runtime.is1_9()) {
                        return new Option(runtime, ProtocolFamily.PF_INET, level2, opt, value2);
                    }
                    return RubyBasicSocket.number(runtime, SocketType.forChannel(channel).getSocketOption(channel, opt));
                }
            }
            throw runtime.newErrnoENOPROTOOPTError();
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (IOException e) {
            throw runtime.newErrnoENOPROTOOPTError();
        }
    }

    @JRubyMethod
    public IRubyObject setsockopt(ThreadContext context, IRubyObject _level, IRubyObject _opt, IRubyObject val) {
        Ruby runtime = context.runtime;
        SocketLevel level2 = RubyBasicSocket.levelFromArg(_level);
        SocketOption opt = RubyBasicSocket.optionFromArg(_opt);
        try {
            Channel channel = this.getOpenChannel();
            SocketType socketType = SocketType.forChannel(channel);
            switch (level2) {
                case SOL_SOCKET: 
                case SOL_IP: 
                case SOL_TCP: 
                case SOL_UDP: {
                    if (opt == SocketOption.SO_LINGER) {
                        if (val instanceof RubyBoolean && !val.isTrue()) {
                            socketType.setSoLinger(channel, false, 0);
                            break;
                        }
                        int num = this.asNumber(val);
                        if (num == -1) {
                            socketType.setSoLinger(channel, false, 0);
                            break;
                        }
                        socketType.setSoLinger(channel, true, num);
                        break;
                    }
                    socketType.setSocketOption(channel, opt, this.asNumber(val));
                    break;
                }
                default: {
                    int intLevel = (int)_level.convertToInteger().getLongValue();
                    int intOpt = (int)_opt.convertToInteger().getLongValue();
                    if (IPProto.IPPROTO_TCP.intValue() == intLevel && TCP.TCP_NODELAY.intValue() == intOpt) {
                        socketType.setTcpNoDelay(channel, this.asBoolean(val));
                        break;
                    }
                    if (IPProto.IPPROTO_IP.intValue() == intLevel) {
                        if (12 == intOpt) {
                            this.joinMulticastGroup(val);
                        }
                        break;
                    }
                    throw runtime.newErrnoENOPROTOOPTError();
                }
            }
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (IOException e) {
            throw runtime.newErrnoENOPROTOOPTError();
        }
        return runtime.newFixnum(0);
    }

    @JRubyMethod(name={"getsockname"})
    public IRubyObject getsockname(ThreadContext context) {
        return this.getSocknameCommon(context, "getsockname");
    }

    @JRubyMethod(name={"getpeername"})
    public IRubyObject getpeername(ThreadContext context) {
        Ruby runtime = context.runtime;
        try {
            InetSocketAddress sock = this.getRemoteSocket();
            if (null == sock) {
                throw runtime.newIOError("Not Supported");
            }
            return runtime.newString(((Object)sock).toString());
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
    }

    @JRubyMethod(name={"getpeereid"}, compat=CompatVersion.RUBY1_9, notImplemented=true)
    public IRubyObject getpeereid(ThreadContext context) {
        throw context.runtime.newNotImplementedError("getpeereid not implemented");
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject local_address(ThreadContext context) {
        try {
            InetSocketAddress address2 = this.getSocketAddress();
            if (address2 == null) {
                return context.nil;
            }
            return new Addrinfo(context.runtime, context.runtime.getClass("Addrinfo"), address2.getAddress(), address2.getPort(), SocketType.forChannel(this.getChannel()));
        }
        catch (BadDescriptorException bde) {
            throw context.runtime.newErrnoEBADFError("address unavailable");
        }
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject remote_address(ThreadContext context) {
        try {
            InetSocketAddress address2 = this.getRemoteSocket();
            if (address2 == null) {
                return context.nil;
            }
            return new Addrinfo(context.runtime, context.runtime.getClass("Addrinfo"), address2.getAddress(), address2.getPort(), SocketType.forChannel(this.getChannel()));
        }
        catch (BadDescriptorException bde) {
            throw context.runtime.newErrnoEBADFError("address unavailable");
        }
    }

    @JRubyMethod(optional=1)
    public IRubyObject shutdown(ThreadContext context, IRubyObject[] args2) {
        int how = 2;
        if (args2.length > 0) {
            how = RubyNumeric.fix2int(args2[0]);
        }
        try {
            return this.shutdownInternal(context, how);
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
    }

    @Override
    @JRubyMethod
    public IRubyObject close_write(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (!this.openFile.isWritable()) {
            return runtime.getNil();
        }
        if (this.openFile.getPipeStream() == null && this.openFile.isReadable()) {
            throw runtime.newIOError("closing non-duplex IO for writing");
        }
        if (!this.openFile.isReadable()) {
            this.close();
        } else {
            try {
                this.shutdownInternal(context, 1);
            }
            catch (BadDescriptorException e) {
                throw runtime.newErrnoEBADFError();
            }
        }
        return context.nil;
    }

    @Override
    @JRubyMethod
    public IRubyObject close_read(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (!this.openFile.isOpen()) {
            throw context.runtime.newIOError("not opened for reading");
        }
        if (!this.openFile.isWritable()) {
            this.close();
        } else {
            try {
                this.shutdownInternal(context, 0);
            }
            catch (BadDescriptorException e) {
                throw runtime.newErrnoEBADFError();
            }
        }
        return context.nil;
    }

    @JRubyMethod(rest=true, notImplemented=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject sendmsg(ThreadContext context, IRubyObject[] args2) {
        throw context.runtime.newNotImplementedError("sendmsg is not implemented");
    }

    @JRubyMethod(rest=true, notImplemented=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject sendmsg_nonblock(ThreadContext context, IRubyObject[] args2) {
        throw context.runtime.newNotImplementedError("sendmsg_nonblock is not implemented");
    }

    @JRubyMethod(rest=true, notImplemented=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject readmsg(ThreadContext context, IRubyObject[] args2) {
        throw context.runtime.newNotImplementedError("readmsg is not implemented");
    }

    @JRubyMethod(rest=true, notImplemented=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject readmsg_nonblock(ThreadContext context, IRubyObject[] args2) {
        throw context.runtime.newNotImplementedError("readmsg_nonblock is not implemented");
    }

    private ByteList doReceive(ThreadContext context, int length2) {
        Ruby runtime = context.runtime;
        ByteBuffer buf = ByteBuffer.allocate(length2);
        try {
            context.getThread().beforeBlockingCall();
            int read2 = this.openFile.getMainStreamSafe().getDescriptor().read(buf);
            if (read2 == 0) {
                ByteList byteList = null;
                return byteList;
            }
            ByteList byteList = new ByteList(buf.array(), 0, buf.position());
            return byteList;
        }
        catch (BadDescriptorException e) {
            throw runtime.newIOError("bad descriptor");
        }
        catch (IOException e) {
            if ("Socket not open".equals(e.getMessage())) {
                throw runtime.newIOError(e.getMessage());
            }
            throw runtime.newSystemCallError(e.getMessage());
        }
        finally {
            context.getThread().afterBlockingCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteList doReceiveNonblock(ThreadContext context, int length2) {
        Ruby runtime = context.runtime;
        Channel channel = this.getChannel();
        if (!(channel instanceof SelectableChannel)) {
            if (runtime.is1_9()) {
                throw runtime.newErrnoEAGAINReadableError(channel.getClass().getName() + " does not support nonblocking");
            }
            throw runtime.newErrnoEAGAINError(channel.getClass().getName() + " does not support nonblocking");
        }
        SelectableChannel selectable = (SelectableChannel)channel;
        Object object = selectable.blockingLock();
        synchronized (object) {
            ByteList byteList;
            boolean oldBlocking = selectable.isBlocking();
            selectable.configureBlocking(false);
            try {
                byteList = this.doReceive(context, length2);
            }
            catch (Throwable throwable) {
                try {
                    selectable.configureBlocking(oldBlocking);
                    throw throwable;
                }
                catch (IOException e) {
                    throw runtime.newIOErrorFromException(e);
                }
            }
            selectable.configureBlocking(oldBlocking);
            return byteList;
        }
    }

    private void joinMulticastGroup(IRubyObject val) throws IOException, BadDescriptorException {
        Channel socketChannel = this.getOpenChannel();
        if (socketChannel instanceof DatagramChannel) {
            if (this.multicastStateManager == null) {
                this.multicastStateManager = new MulticastStateManager();
            }
            if (val instanceof RubyString) {
                byte[] ipaddr_buf = val.convertToString().getBytes();
                this.multicastStateManager.addMembership(ipaddr_buf);
            }
        }
    }

    protected InetSocketAddress getSocketAddress() throws BadDescriptorException {
        Channel channel = this.getOpenChannel();
        return (InetSocketAddress)SocketType.forChannel(channel).getLocalSocketAddress(channel);
    }

    protected InetSocketAddress getRemoteSocket() throws BadDescriptorException {
        Channel channel = this.getOpenChannel();
        return (InetSocketAddress)SocketType.forChannel(channel).getRemoteSocketAddress(channel);
    }

    protected Sock getDefaultSocketType() {
        return Sock.SOCK_STREAM;
    }

    protected IRubyObject getSocknameCommon(ThreadContext context, String caller2) {
        try {
            InetSocketAddress sock = this.getSocketAddress();
            if (null == sock) {
                return Sockaddr.pack_sockaddr_in(context, 0, "0.0.0.0");
            }
            return Sockaddr.pack_sockaddr_in(context, sock);
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
    }

    private IRubyObject shutdownInternal(ThreadContext context, int how) throws BadDescriptorException {
        Ruby runtime = context.runtime;
        switch (how) {
            case 0: {
                Channel channel = this.getOpenChannel();
                try {
                    SocketType.forChannel(channel).shutdownInput(channel);
                }
                catch (IOException e) {
                    throw runtime.newIOError(e.getMessage());
                }
                if (this.openFile.getPipeStream() != null) {
                    this.openFile.setMainStream(this.openFile.getPipeStream());
                    this.openFile.setPipeStream(null);
                }
                this.openFile.setMode(this.openFile.getMode() & 0xFFFFFFFE);
                return RubyFixnum.zero(runtime);
            }
            case 1: {
                Channel channel = this.getOpenChannel();
                try {
                    SocketType.forChannel(channel).shutdownOutput(channel);
                }
                catch (IOException e) {
                    throw runtime.newIOError(e.getMessage());
                }
                this.openFile.setPipeStream(null);
                this.openFile.setMode(this.openFile.getMode() & 0xFFFFFFFD);
                return RubyFixnum.zero(runtime);
            }
            case 2: {
                this.shutdownInternal(context, 0);
                this.shutdownInternal(context, 1);
                return RubyFixnum.zero(runtime);
            }
        }
        throw runtime.newArgumentError("`how' should be either 0, 1, 2");
    }

    public boolean doNotReverseLookup(ThreadContext context) {
        return context.runtime.isDoNotReverseLookupEnabled() || this.doNotReverseLookup;
    }

    protected void initSocket(Ruby runtime, ChannelDescriptor descriptor) {
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(ChannelStream.fdopen(runtime, descriptor, RubyBasicSocket.newModeFlags(runtime, ModeFlags.RDONLY)));
            this.openFile.setPipeStream(ChannelStream.fdopen(runtime, descriptor, RubyBasicSocket.newModeFlags(runtime, ModeFlags.WRONLY)));
            this.openFile.getPipeStream().setSync(true);
        }
        catch (InvalidValueException ex) {
            throw runtime.newErrnoEINVALError();
        }
        this.openFile.setMode(11);
        this.setAscii8bitBinmode();
    }

    private Channel getOpenChannel() throws BadDescriptorException {
        return this.getOpenFileChecked().getMainStreamSafe().getDescriptor().getChannel();
    }

    private int asNumber(IRubyObject val) {
        if (val instanceof RubyNumeric) {
            return RubyNumeric.fix2int(val);
        }
        if (val instanceof RubyBoolean) {
            return val.isTrue() ? 1 : 0;
        }
        return this.stringAsNumber(val);
    }

    private int stringAsNumber(IRubyObject val) {
        ByteList str = val.convertToString().getByteList();
        IRubyObject res = Pack.unpack(this.getRuntime(), str, FORMAT_SMALL_I).entry(0);
        if (res.isNil()) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        return RubyNumeric.fix2int(res);
    }

    protected boolean asBoolean(IRubyObject val) {
        if (val instanceof RubyString) {
            return this.stringAsNumber(val) != 0;
        }
        if (val instanceof RubyNumeric) {
            return RubyNumeric.fix2int(val) != 0;
        }
        return val.isTrue();
    }

    private static IRubyObject number(Ruby runtime, int s2) {
        return RubyString.newString(runtime, Pack.packInt_i(new ByteList(4), s2));
    }

    protected static SocketOption optionFromArg(IRubyObject _opt) {
        SocketOption opt = _opt instanceof RubyString || _opt instanceof RubySymbol ? SocketOption.valueOf(_opt.toString()) : SocketOption.valueOf(RubyNumeric.fix2int(_opt));
        return opt;
    }

    protected static SocketLevel levelFromArg(IRubyObject _level) {
        SocketLevel level2 = _level instanceof RubyString || _level instanceof RubySymbol ? SocketLevel.valueOf(_level.toString()) : SocketLevel.valueOf(RubyNumeric.fix2int(_level));
        return level2;
    }

    protected IRubyObject addrFor(ThreadContext context, InetSocketAddress addr2, boolean reverse2) {
        Ruby r = context.runtime;
        IRubyObject[] ret = new IRubyObject[4];
        ret[0] = r.newString("AF_INET");
        ret[1] = r.newFixnum(addr2.getPort());
        String hostAddress = addr2.getAddress().getHostAddress();
        ret[2] = !reverse2 || this.doNotReverseLookup(context) ? r.newString(hostAddress) : r.newString(addr2.getHostName());
        ret[3] = r.newString(hostAddress);
        return r.newArrayNoCopy(ret);
    }

    @Deprecated
    public IRubyObject recv(IRubyObject[] args2) {
        return this.recv(this.getRuntime().getCurrentContext(), args2);
    }

    @Deprecated
    public IRubyObject getsockopt(IRubyObject lev, IRubyObject optname2) {
        return this.getsockopt(this.getRuntime().getCurrentContext(), lev, optname2);
    }

    @Deprecated
    public IRubyObject setsockopt(IRubyObject lev, IRubyObject optname2, IRubyObject val) {
        return this.setsockopt(this.getRuntime().getCurrentContext(), lev, optname2, val);
    }

    @Deprecated
    public IRubyObject getsockname() {
        return this.getsockname(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public IRubyObject getpeername() {
        return this.getpeername(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public static IRubyObject do_not_reverse_lookup(IRubyObject recv2) {
        return RubyBasicSocket.do_not_reverse_lookup(recv2.getRuntime().getCurrentContext(), recv2);
    }

    @Deprecated
    public static IRubyObject set_do_not_reverse_lookup(IRubyObject recv2, IRubyObject flag) {
        return RubyBasicSocket.set_do_not_reverse_lookup(recv2.getRuntime().getCurrentContext(), recv2, flag);
    }
}

